<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Creates a Form Tab
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class TabViewHelper extends AbstractAggregateViewHelper
{
    public static $tabCount = 0;
    public static $hasRequiredFields = false;

    protected $number = 0;
    protected $tabId = '';
    protected $title = '';

    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('title', 'string', 'The title of the tab.', true, '');
        $this->registerArgument('class', 'string', 'Extra Classes for header and Draws', false);
        $this->registerArgument('headerClass', 'string', 'Extra Classes for header', false);
        $this->registerArgument('disableRequiredHint', 'boolean', 'Disable the legend for asterisk symbols.', false, false);
    }

    /**
     * Renders a tab and registers itself for tabMenu Creation.
     *
     * @return string
     * @api
     */
    public function render()
    {
        $tabsUtility = GeneralUtility::makeInstance(\Internetgalerie\IgRender\Utility\TabsUtility::class);
        $tab = $tabsUtility->addTitle($this->arguments['title'], $this->arguments['headerClass'], $this->arguments['name']);
        $activeTabName = $tabsUtility->getActiveTabName();
        //parent::render();

        $this->title = $this->arguments['title'];
        $this->number = self::$tabCount++;
        $this->tabId = 'dp-tab-' . $this->number;

        $classes = array('dp-tabPage', 'dp-tabPage-' . $this->number, );

        self::$hasRequiredFields = false;
        $content = $this->renderChildren();//$this->renderAggregateChildren();

        $out = '';
        $out .= $this->renderTabHeader('div', 'tabDrawer');

        //more classes
        if ($this->hasError()) {
            $classes[] = 'dp-tabPage-error';
        }
        if ($this->hasArgument('class')) {
            $classes[] = $this->arguments['class'];
        }

        /*
        if (FormViewHelper::$curForm->isStepForm()) {
            if (FormViewHelper::$curForm->getCurrentStep() != $this->getTabNumber()) {
                return '';
            }
            $classes[] = 'dp-tabPage-forceActive';
        }
        */
        $out .= '<div class="' . implode(' ', $classes) . '" id="' . $tab['name'] . '">';//'.($this->number>0 ? ' style="display:none;"': '').'
        $out .= $content;
        if (!$this->arguments['disableRequiredHint'] && self::$hasRequiredFields) {
            $out .= '<div class="dp-requiredHint">' . \Internetgalerie\IgDatapoolFe\Services\LangService::ll('label.required') . '</div>';
        }
        $out .= '
</div>
';
        return $out;
    }

    public function getTabId()
    {
        return $this->tabId;
    }

    public function getTabTitle()
    {
        return $this->title;
    }

    public function getTabNumber()
    {
        return $this->number;
    }

    public function renderTabHeader($elem, $baseClass)
    {
        $classes = array('dp-' . $baseClass);
        $classes[] = 'dp-' . $baseClass . '-' . $this->getTabNumber();
        if ($this->hasError()) {
            $classes[] = 'dp-' . $baseClass . '-error';
        }
        if ($this->hasArgument('class') && $elem=='li') {
            $classes[] = $this->arguments['class'];
        }
        if ($this->hasArgument('headerClass') && $elem=='li') {
            $classes[] = $this->arguments['headerClass'];
        }

        //tabsToSteps: enable if current
        if (FormViewHelper::$curForm->isStepForm() && FormViewHelper::$curForm->getCurrentStep() == $this->getTabNumber()) {
            $classes[] = 'dp-' . $baseClass . '-active';
        }

        //tab header / navigation rendering
        return '<' . $elem . ' class="' . implode(' ', $classes) . '" data-rel="' . $this->getTabNumber() . '">
	<a class="dp-' . $baseClass . '-link" href="#' . $this->getTabId() . '" onclick="return false">' . htmlspecialchars($this->getTabTitle()) . '</a>
</' . $elem . '>';
    }
}
