/**
 * Slider UI Elements
 */
IGDATAPOOLFE.plugins.add('slider', {
    form: null,
    initFields: function(form) {
	this.init(form);
    },
    init: function(form) {
	let $form = $(form);
	this.form = $form;
	$('.dp-slider', $form).each(function() {
	    var $input = $('input', this);
	    var current = parseInt($input.val()) ? parseInt($input.val()) : parseInt($input.data('min'));
	    $('.slider', this).slider({
		min : parseInt($input.data('min')),
		max : parseInt($input.data('max')),
		step : parseFloat($input.data('step')),
		orientation : $input.data('orientation'),
		value : current,
		slide : function(event, ui) {
		    $input.val(ui.value);
		}
	    });
	});
	$('.dp-spinner', $form).each(function() {
	    var $input = $('input', this);
	    var options= {};
	    if(  $input.data('min') !== null ) {
		options.min=$input.data('min');
	    }
	    if(  $input.data('max') !== null ) {
		options.max=$input.data('max');
	    }
	    if(  $input.data('step') ) {
		options.step=$input.data('step');
	    }
	    $('input', this).spinner( options );
	});
    }
});