<?php

declare(strict_types=1);

use Internetgalerie\IgDatapoolFe\Controller\AjaxUploadController;
use Internetgalerie\IgDatapoolFe\Mvc\Property\PropertyMappingConfiguration;
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;

//use Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter;
//use TYPO3\CMS\Extbase\Utility\ExtensionUtility;

defined('TYPO3') or die();


if ((new \TYPO3\CMS\Core\Information\Typo3Version())->getMajorVersion() < 12)
{

    /**
     * DateTime Converter for dates without seconds
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter::class);

   \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\HtmlConverter::class);

    /**
     * Type Converter for FileReferences
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileReferenceConverter::class);

    /**
     * Type Converter for ObjectStorage: does not store NULL
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\ObjectStorageConverter::class);


    /**
     * Type Converter for File
     */
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerTypeConverter(\Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileConverter::class);
}

ExtensionUtility::configurePlugin(
    // extension name, matching the PHP namespaces (but without the vendor)
    'IgDatapoolFe',
    // arbitrary, but unique plugin name (not visible in the backend)
    'AjaxUpload',
    // all actions
    [AjaxUploadController::class => 'ajaxUpload'],
    // non-cacheable actions
    [AjaxUploadController::class => 'ajaxUpload'],
);