<?php

namespace Internetgalerie\IgDatapoolFe\Domain\Model;

use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

if (VersionNumberUtility::convertVersionNumberToInteger(VersionNumberUtility::getNumericTypo3Version()) < 12000000) {
    class SystemCountry extends \SJBR\StaticInfoTables\Domain\Model\Country {
        public function getLocalizedName(): string
        {
            return $this->shortNameDe;
        }
        public function getAlpha2IsoCode(): string
        {
            return $this->getIsoCodeA2();
        }

    };
} else {
    class SystemCountry extends \TYPO3\CMS\Core\Country\Country {
        public function getLocalizedName(): string
        {
            $localizedNameLabel = $this->getLocalizedNameLabel();
            return $localizedNameLabel ? LocalizationUtility::translate($localizedNameLabel) : $this->name;
        }
        public function getIsoCodeA2(): string
        {
            return $this->alpha2;
        }
        public function getIso2(): string
        {
            return $this->alpha2;
        }
    }
}


class Country extends SystemCountry
{
    /**
    * The German short name
    * @var string
    */
    protected $shortNameDe = '';

    /**
     * The French short name
     *
     * @var string
     */
    protected $shortNameFr = '';

    /**
    * The Italian short name
    * @var string
    */
    protected $shortNameIt = '';


    /**
    * Sets the German short name.
    *
    * @param string $shortNameDe
    *
    * @return void
    */
    public function setShortNameDe($shortNameDe): void
    {
        $this->shortNameDe = $shortNameDe;
    }

    /**
    * Gets the German short name.
    *
    * @return string
    */
    public function getShortNameDe()
    {
        return $this->shortNameDe;
    }

    /**
     * Gets the French short name.
     *
     * @return string
     */
    public function getShortNameFr()
    {
        return $this->shortNameFr;
    }

    /**
     * Sets the French short name.
     *
     * @param string $shortNameFr
     *
     * @return void
     */
    public function setShortNameFr($shortNameFr): void
    {
        $this->shortNameFr = $shortNameFr;
    }

    /**
    * Sets the Italian short name.
    *
    * @param string $shortNameIt
    *
    * @return void
    */
    public function setShortNameIt($shortNameIt): void
    {
        $this->shortNameIt = $shortNameIt;
    }

    /**
    * Gets the Italian short name.
    *
    * @return string
    */
    public function getShortNameIt()
    {
        return $this->shortNameIt;
    }
}
