<?php

namespace Internetgalerie\IgDatapoolFe\Services;

use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Resource\ResourceFactory;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This calss provides methods for acces checking and authorization
 */
class FormService implements SingletonInterface
{
    public const SUBFOLDER_NONE =0;
    public const SUBFOLDER_EXTENSION_CONTROLLER =1;
    public const SUBFOLDER_FEUSERID =2;


    /**
     * @var ResourceFactory
     */
    protected $resourceFactory;

    /**
     * Store the current controller
     */
    protected $controller = null;

    /**
     * Upload Folder
     */
    protected $uploadFolder = [];
    /**
     * Default Upload Folder
     */
    protected $defaultUploadFolder = '1:/';

    /**
     * Default Subfolder Upload Folder
     */
    protected $defaultSubfolderMode = self::SUBFOLDER_EXTENSION_CONTROLLER;

    /**
     * Store the last field
     */
    protected $field = null;

    /**
     * @param ResourceFactory $resourceFactory
     */
    public function injectResourceFactory(ResourceFactory $resourceFactory): void
    {
        $this->resourceFactory = $resourceFactory;
    }

    public function setController($controller): void
    {
        $this->controller = $controller;
    }
    public function getController()
    {
        return $this->controller;
    }

    public function setDefaultSubfolderMode($defaultSubfolderMode): void
    {
        $this->defaultSubfolderMode = $defaultSubfolderMode;
    }
    public function getDefaultSubfolderMode()
    {
        return $this->defaultSubfolderMode;
    }



    public function setDefaultUploadFolder(string $defaultUploadFolder): void
    {
        $this->defaultUploadFolder = $defaultUploadFolder;
    }
    public function getDefaultUploadFolder()
    {
        return $this->defaultUploadFolder;
    }
    public function getUploadFolder($propertyFolder = null, $subFolder = '')
    {
        $uploadFolderString=$this->defaultUploadFolder;
        /*
        if( $property!==null) {
            die('missing');
        }
        */
        $resourceStorage = $this->resourceFactory->getStorageObjectFromCombinedIdentifier($uploadFolderString);
        $rf=explode(':', (string) $uploadFolderString);
        if (count($rf)!=2) {
            die('identifier not allowed: ' . $uploadFolderString);
        }
        $folder=trim($rf[1], '/');
        if ($this->defaultSubfolderMode==self::SUBFOLDER_EXTENSION_CONTROLLER && $this->controller) {
            $request = $this->controller->getRequest();
            $folder .= '/' . $request->getControllerExtensionName() . '/' . $request->getControllerName();
        } elseif ($this->defaultSubfolderMode==self::SUBFOLDER_FEUSERID) {
            $context = GeneralUtility::makeInstance(Context::class);
            $frontendUserId = $context->getPropertyFromAspect('frontend.user', 'id');
            if ($frontendUserId > 0) {
                $folder .= '/' . $frontendUserId;
            } else {
                die('fronend user is required');
            }
        } elseif(!$propertyFolder) {
            $folder .= '/ext/form/uploads';

            if($subFolder) {
                $folder = $subFolder;
            }
        }
        if ($propertyFolder) {
            $folder.= '/' . $propertyFolder;
        }
        if ($resourceStorage->hasFolder($folder)) {
            return $resourceStorage->getFolder($folder);
        } else {
            return $resourceStorage->createFolder($folder);
        }
    }



    public function setField($field): void
    {
        $this->field = $field;
    }
    public function getField()
    {
        return $this->field;
    }
}
