<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;
use Internetgalerie\IgDatapoolFe\ViewHelpers\SearchFormViewHelper;

/**
 * Provides accessors for use with the tabs / fieldwarpper engine.
 */
trait FormFieldTrait
{
    public function getFormClass()
    {
        if ($this->viewHelperVariableContainer->exists(FormViewHelper::class, 'formClass')) {
            return  $this->viewHelperVariableContainer->get(FormViewHelper::class, 'formClass');
        }
        return false;
    }

    /**
     * Add support for default value. must be registred by the specific fieldtype!!
     *
     * @see TYPO3\CMS\Fluid\ViewHelpers\Form\AbstractFormFieldViewHelper
     *
     * Get the value of this form element.
     * Either returns arguments['value'], or the correct value for Object Access.
     *
     * @param  boolean $convertObjects whether or not to convert objects to identifiers
     * @return mixed Value
     */

    protected function getValueAttribute($convertObjects = true)
    {
        // EDIT MB
        // Searchform Value
        //if ($this->isSearchForm()) {
        if ($formClass = $this->getFormClass()) {
            if ($formClass == SearchFormViewHelper::class) {
                $requestArguments = [];
                if ($this->renderingContext->getRequest()->hasArgument('@search')) {
                    $requestArguments = $this->renderingContext->getRequest()->getArgument('@search');

                    $value = null;
                    if ($this->respectSubmittedDataValue && isset($requestArguments[$this->arguments['name']]) && $requestArguments[$this->arguments['name']]!='') {
                        return $requestArguments[$this->arguments['name']];
                    } elseif ($this->hasArgument('value')) {
                        $value = $this->arguments['value'];
                    } elseif ($this->isObjectAccessorMode()) {
                        $value = $this->getPropertyValue();
                    }

                    $value = $this->convertToPlainValue($value);
                    return $value;
                }
            }
        }
        // end edit mb

        $value = null;
        if ($this->hasArgument('value')) {
            $value = $this->arguments['value'];
        } elseif ($this->hasMappingErrorOccurred()) {
            $value = $this->getLastSubmittedFormData();

        // here we have to add additionalidedentiyfield!!!!
        } elseif ($this->isObjectAccessorMode()) {
            $value = $this->getPropertyValue();
            // XXX: Is this line correct here? only works with ObjectAccessorMode and no default is set in model
            if (null === $value && isset($this->arguments['default'])) {
                $value = $this->arguments['default'];
            }
        }
        if ($convertObjects === true && is_object($value)) {
            $identifier = $this->persistenceManager->getIdentifierByObject($value);
            if ($identifier !== null) {
                $value = $identifier;
            }
        }
        if ($this->viewHelperVariableContainer->exists(FormViewHelper::class, 'formObject')) {
            $this->addAdditionalIdentityPropertiesIfNeeded();
        }
        return $value;
    }
    protected function generateId($arguments)
    {
        $fieldId = $fieldId = 'dp-field-' . str_replace('.', '-', strtolower((string) $arguments['property']));

        return $fieldId;
    }
    /**
     * Check if field has a validation error
     *
     * @return boolean
     */
    public function hasError()
    {
        return $this->getMappingResultsForProperty()->hasErrors();
    }
}
