<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Select;

use Internetgalerie\IgDatapoolFe\ViewHelpers\Form\SelectViewHelper;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class CheckboxViewHelper extends SelectViewHelper
{
    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('columns', 'int', 'columns', false, 1);
        $this->registerArgument('classes', 'string', 'classes', false, '');
        $this->registerArgument('selectAll', 'int', 'selectAll', false, false);

        //$this->registerArgument('search', 'int', 'search', false, false);
        //$this->registerArgument('textsSearch', 'string', 'textsSearch', false, '');

        $this->registerArgument('filter', 'int', 'filter', false, false);
        $this->registerArgument('textsFilterPlaceholder', 'string', 'textsFilterPlaceholder', false, '');
        $this->registerArgument('textsFilterLabel', 'string', 'textsFilterLabel', false, '');

        $this->registerArgument('textsPlaceholder', 'string', 'textsPlaceholder', false, '');
        $this->registerArgument('textsSelectAll', 'string', 'textsSelectAll', false, '');
        $this->registerArgument('textsUnselectAll', 'string', 'textsUnselectAll', false, '');
        $this->registerArgument('textsClose', 'string', 'textsClose', false);

        $this->registerArgument('buttonWidth', 'string', 'buttonWidth', false, null);
        $this->registerArgument('selectedText', 'string', 'selectedText', false, '# of # selected');
        $this->registerArgument('selectedList', 'int', 'selectedList', false, 0);
        $this->registerArgument('selectedListSeparator', 'string', 'selectedListSeparator', false, ', ');
        $this->registerArgument('maxSelected', 'int', 'maxSelected', false, null);
        $this->registerArgument('textsMaxSelected', 'string', 'textMaxSelected', false, null);
        $this->registerArgument('menuWidth', 'string', 'menuWidth', false, null);
        $this->registerArgument('menuHeight', 'string', 'menuWidth', false, null);
        $this->registerArgument('header', 'string', 'headers: checkAll, uncheckAll, flipAll, collapseAll, or expandAll', false, 'checkAll,uncheckAll');
    }


    /**
     * Render the tag.
     *
     * @return string rendered tag.
     * @api
     */
    public function render(): string
    {
        $pageRenderer=GeneralUtility::makeInstance(PageRenderer::class);

        // Bis 7.6 voller Pfad angeben
        //$pageRenderer->addJsFooterLibrary( 'select2', GeneralUtility::getFileAbsFileName('EXT:ig_datapool_fe/Resources/Public/JavaScript/select2.min.js'));

        if (1) {
            $pageRenderer->addJsFooterLibrary('jquery.multiselect', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery-ui-multiselect-widget/src/jquery.multiselect.js');
            //if ($this->arguments['filter']==1) {
            $pageRenderer->addJsFooterLibrary('jquery.multiselect-filter', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery-ui-multiselect-widget/src/jquery.multiselect.filter.js');
            //}
            $pageRenderer->addJsFooterLibrary('jquery.multiselect-init', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery-ui-multiselect-widget/jquery-ui-multiselect-widget-init.js');
            $pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery-ui-multiselect-widget/css/jquery.multiselect.css');
        } else {
            $pageRenderer->addJsFooterLibrary('jquery.multiselect', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jQuery-MultiSelect/jquery.multiselect.js');
            $pageRenderer->addJsFooterLibrary('jquery.multiselect-init', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jQuery-MultiSelect/jquery.multiselect-init.js');
            $pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/Css/jquery.multiselect.css');
        }
        $class= 'dp-select-checkbox';


        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', $class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class']= $class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', $class);
            $this->arguments['class']= $class;
        }
        //$this->tag->addAttribute('style', 'width: 100%;');
        //$this->tag->addAttribute('data-columns', (int)$this->arguments['columns']);

        //$this->tag->addAttribute('data-search', (int)$this->arguments['search']);
        //$this->tag->addAttribute('data-texts-search', $this->arguments['textsSearch']);
        $classes =$this->arguments['classes'];
        if ($this->arguments['columns']>1) {
            $classes = trim($classes . ' ' . 'columns-multi columns-' . intval($this->arguments['columns']));
        }
        $selectedValues = $this->getSelectedValue();
        if (!empty($selectedValues)) {
            $classes = trim((string) $classes) . ' selected';
        }
        $this->tag->addAttribute('data-classes', $classes);


        $this->tag->addAttribute('data-texts-placeholder', $this->arguments['textsPlaceholder']);
        $this->tag->addAttribute('data-select-all', (int)$this->arguments['selectAll']);
        $this->tag->addAttribute('data-max-selected', $this->arguments['maxSelected']);
        $this->tag->addAttribute('data-texts-max-selected', $this->arguments['textsMaxSelected']);
        $this->tag->addAttribute('data-texts-select-all', $this->arguments['textsSelectAll']);
        $this->tag->addAttribute('data-texts-unselect-all', $this->arguments['textsUnselectAll']);
        $this->tag->addAttribute('data-texts-close', $this->arguments['textsClose']);

        $this->tag->addAttribute('data-header', json_encode(explode(',', (string) $this->arguments['header'])));
        $this->tag->addAttribute('data-selected-text', $this->arguments['selectedText']);
        $this->tag->addAttribute('data-selected-list', $this->arguments['selectedList']);
        $this->tag->addAttribute('data-selected-list-separator', $this->arguments['selectedListSeparator']);
        $this->tag->addAttribute('data-button-width', $this->arguments['buttonWidth']);
        $this->tag->addAttribute('data-menu-width', $this->arguments['menuWidth']);
        $this->tag->addAttribute('data-menu-height', $this->arguments['menuHeight']);
        if ($this->arguments['filter']) {
            $this->tag->addAttribute('data-filter', $this->arguments['filter']);
            $this->tag->addAttribute('data-texts-filter-placeholder', $this->arguments['textsFilterPlaceholder']);
            $this->tag->addAttribute('data-texts-filter-label', $this->arguments['textsFilterLabel']);
        }
        return parent::render();
    }
}
