<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

use TYPO3\CMS\Extbase\Service\ExtensionService;

trait ViewHelperTrait
{
    /**
     * @var ExtensionService
     */
    protected $extensionService;

    protected $prefix = null;

    /**
     * @param ExtensionService $extensionService
     */
    public function injectExtensionService(ExtensionService $extensionService): void
    {
        $this->extensionService = $extensionService;
    }
    /**
     * Returns the prefix for link arguments
     */
    public function getLinkPrefix()
    {
        if ($this->prefix == null) {
            $request = $this->renderingContext->getRequest();
            $extensionName = $request->getControllerExtensionName();
            $pluginName = $request->getPluginName();
            if ($extensionName !== null && $pluginName != null) {
                $this->prefix = $this->extensionService->getPluginNamespace($extensionName, $pluginName);
            } else {
                $this->prefix = '';
            }
        }
        return $this->prefix;
    }
}
