<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use Internetgalerie\IgDatapoolFe\Utility\NeedfulThings;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\SelectViewHelper;

class Select2ViewHelper extends SelectViewHelper
{
    use FormFieldTrait;

    protected static $pageRenderer = null;
    protected static $class = 'dp-select2';
    protected static $style = '';
    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('default', 'mixed', 'Default Value');
        $this->registerArgument('placeholder', 'string', 'placeholder String', false, '');
        $this->registerArgument('closeOnSelect', 'boolean', 'placeholder String', false, true);
        $this->registerArgument('dropdownCssClass', 'string', 'placeholder String', false, '');
        $this -> registerArgument('allowClear', 'boolean', 'display a clear button ("x" icon) to appear on the select box when a value is selected.', false, false);
    }

    /**
     * adds default JS for select2 and returns pageRenderer for further js/css
     */
    public function createPageRendererForSelect2(): void
    {
        if (static::$pageRenderer === null) {
            $request = $this->renderingContext->getRequest();
            $siteLanguage = $request->getAttribute('language', null);
            $isoCode = $siteLanguage->getLocale()->getLanguageCode();

            static::$pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
            static::$pageRenderer->addJsFooterLibrary('select2', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/select2/select2.full.js');
            static::$pageRenderer->addJsFooterLibrary('select2-init', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/select2/datapool-init.js');
            static::$pageRenderer->addJsFooterLibrary('select2-local', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/select2/i18n/' . $isoCode . '.js');
            //$pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/Css/select2.css');
        }
    }
        
    public function render(): string
    {
        $this->createPageRendererForSelect2();

        if (isset($this->arguments['placeholder'])) {
            $this->tag->addAttribute('data-placeholderlabel', $this->arguments['placeholder']);
        }

        if (isset($this->arguments['closeOnSelect'])) {
            $this->tag->addAttribute('data-close-on-select', $this->arguments['closeOnSelect'] ? 1 : 0);
        }

        if (isset($this->arguments['dropdownCssClass'])) {
            $this->tag->addAttribute('data-dropdown-css-class', $this->arguments['dropdownCssClass']);
        }

        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', static::$class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class']= static::$class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', static::$class);
            $this->arguments['class']= static::$class;
        }

        if ($this->hasArgument('placeholder') && $this->arguments['allowClear']) {
            $this->tag->addAttribute('data-allow-clear', ($this->arguments['allowClear'] ? 'true' : 'false'));
        }
        if (static::$style) {
            $this->tag->addAttribute('style', static::$style);
        }
        return parent::render();
    }
}
