<?php

namespace Internetgalerie\IgDatapoolFe\Domain\Interfaces;

/**
 * Enables recursive lists for input elements.
 *
 * Demo:
 *
 * class Categorie [...] implements RecursiveObjectInterface{
 * [...]
 *     public function isSelectable() {
 *         return false; // only objects can be selected!
 *     }
 *
 *     public function getChildren() {
 *         if ($this -> getSubCategories() -> count() > 0) {
 *             return $this -> getSubCategories();
 *         } else {
 *             return $this -> objectRepository -> findByCategorie($this);
 *         }
 *    }
 * }
 */
interface RecursiveObjectInterface
{
    /**
     * This is used, when you pass a parent object with childs of another model, but only the children are selectable.
     * Like, i.e., Categories with Objects, categories are NOT selectable, but the Objects are.
     */
    public function isSelectable();

    public function getChildren();
}
