<?php

namespace Internetgalerie\IgDatapoolFe\Event;

use Psr\EventDispatcher\StoppableEventInterface;

final class FileUploadBeforeMoveToEvent implements StoppableEventInterface {
    public function __construct(private ?string $uploadFolder = null, private ?string $fileName = null, private $conflictMode = null)
    {
    }

    public function getFileName(): ?string
    {
        return $this->fileName;
    }

    public function setFileName(?string $fileName): void
    {
        $this->fileName = $fileName;
    }

    public function getUploadFolder(): ?string
    {
        return $this->uploadFolder;
    }

    public function setUploadFolder(?string $uploadFolder): void
    {
        $this->uploadFolder = $uploadFolder;
    }

    public function getConflictMode()
    {
        return $this->conflictMode;
    }

    public function setConflictMode($conflictMode): void
    {
        $this->conflictMode = $conflictMode;
    }

    public function isPropagationStopped(): bool
    {
        return false;
    }

}




