<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use DateTime;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;

abstract class AbstractDatetimeViewHelper extends TextfieldViewHelper
{
    protected static $typeConverterFormatSubmitReplaces = [
        'yyyy' => 'Y',
        'yy' => 'y',
        'mm' => 'm',
        'dd' => 'd',
        //'HH' => 'H',
        //'mm' => 'i',
        //'ss' => 's',
    ];

    protected function getInputDateFormat(): string
    {
        // CAVEAT: this has to match the formatSubmit (format in js: yyyy-mm-dd, format in php Y-m-d)
        $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
        return '<input type="hidden" name="' . parent::getName() . '[dateFormat]" value="' . htmlspecialchars((string) $typeConverterDateFormat) . '" />';
    }
    
    protected function getName(): string
    {
        return parent::getName() . '[date]';
    }

    /**
     * Get the value of this form element.
     * Either returns arguments['value'], or the correct value for Object Access.
     *
     * @param  boolean $convertObjects whether or not to convert objects to identifiers
     * @return mixed Value
     */
    protected function getValueAttribute($convertObjects = true)
    {
        $value = parent::getValueAttribute();
        if (is_array($value)) {
            $converter = GeneralUtility::makeInstance(DateTimeConverter::class);
            // set default dateformat if nothing is set
            if (isset($value['date']) && (!isset($value['dateFormat']) || $value['dateFormat'] === '')) {
                $value['dateFormat'] = $this->getTypeConverterFormatSubmit();
            }
            $value = $converter->convertFrom($value, 'DateTime', [], null);
        }

        if (is_a($value, DateTime::class)) {
            //$typeConverterDateFormat = $this->getTypeConverterDateFormat();
            $typeConverterDateFormat = $this->getTypeConverterFormatSubmit();
            return $value->format($typeConverterDateFormat);
        }
        return $value;
    }

    /**
     * Format date for
     */
    protected function getTypeConverterFormatSubmit()
    {
        if (isset($this->arguments['typeConverterDateFormat'])) {
            return $this->arguments['typeConverterDateFormat'];
        }
        $typeConverterDateFormat = $this->arguments['formatSubmit'];
        return str_replace(
            array_keys(static::$typeConverterFormatSubmitReplaces),
            array_values(static::$typeConverterFormatSubmitReplaces),
            $typeConverterDateFormat
        );
    }

    /**
     * Format date for output
     */
    protected function getTypeConverterDateFormat()
    {
        $typeConverterDateFormat = $this->arguments['dateFormat'];
        return str_replace(
            array_keys(static::$typeConverterFormatSubmitReplaces),
            array_values(static::$typeConverterFormatSubmitReplaces),
            $typeConverterDateFormat
        );
    }
}
