<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

/**
 * Renders an AJAX ObjectStorage of FileReferences Field.
 */
class FileReferencesViewHelper extends AbstractFileReferenceViewHelper
{
    // max Files to Upload
    protected $maxUploads=10;


    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('maxUploads', 'int', 'Max number of simultaneous uploads.', false, 10);
    }

    /**
     * Renders the upload field with possible resource pointer
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $this->formUtility->addJsFooter();
        $this->prepareOptions();

        $this->options['multiple']=true;
        $this->options['multipleSelect']=true;

        if ($this->dragAndDrop) {
            $this->cssClasses[]='dp-dropzone';
        }

        $value = $this->getUploadedResource();


        return $this->renderHtml($value);
    }
}
