<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use Internetgalerie\IgDatapoolFe\Utility\NeedfulThings;

/**
 * Textarea view helper.
 * The value of the text area needs to be set via the "value" attribute, as with all other form ViewHelpers.
 *
 * = Examples =
 *
 * <code title="Example">
 * <f:form.textarea name="myTextArea" value="This is shown inside the textarea" />
 * </code>
 * <output>
 * <textarea name="myTextArea">This is shown inside the textarea</textarea>
 * </output>
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class RteViewHelper extends TextareaViewHelper implements FieldInterface
{
    use FormFieldTrait;
    //use FieldTrait;



    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('plugins', 'string', 'plugins to load', false, '');
        $this->registerArgument('toolbarLine1', 'string', 'toolbar https://www.tinymce.com/docs/advanced/editor-control-identifiers/#toolbarcontrols', false, '');
        $this->registerArgument('toolbarLine2', 'string', 'toolbar https://www.tinymce.com/docs/advanced/editor-control-identifiers/#toolbarcontrols', false, '');
        /*        $this->registerArgument('plugins', 'string', 'plugins to load', false, 'hr');
        $this->registerArgument('toolbarLine1', 'string', 'toolbar https://www.tinymce.com/docs/advanced/editor-control-identifiers/#toolbarcontrols', false, "undo redo | styleselect | bold italic | hr | alignleft aligncenter alignright alignjustify");
        $this->registerArgument('toolbarLine2', 'string', 'toolbar https://www.tinymce.com/docs/advanced/editor-control-identifiers/#toolbarcontrols', false, "bullist numlist outdent indent");
        */
        $this->registerArgument('config', 'string', 'configuration/style to use', false, "default");
    }



    /**
     * Renders the textarea.
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $GLOBALS['TSFE']->additionalFooterData['ig_datapool_fe_mce'] = '
<script src="/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/tinymce/tinymce.min.js" data-ignore="1"></script>';

        $name = $this->getName();

        $this->registerFieldNameForFormTokenGeneration($name);

        $this->tag->forceClosingTag(true);
        $this->tag->addAttribute('name', $name);
        $this->tag->addAttribute('id', 'dp-field-rte-' . $this->arguments['property'] ?? str_replcae(['[', ']', '.'], '-', $name));
        $this->tag->setContent(htmlspecialchars((string) $this->getValueAttribute()));

        $this->setErrorClassAttribute();
        $lang = NeedfulThings::getCurLang($this->renderingContext->getRequest(), 'de');

        if ($this->arguments['plugins']) {
            $data_plugins= 'data-plugins="' . $this->arguments['plugins'] . '"';
        } else {
            $data_plugins= '';
        }
        if ($this->arguments['toolbarLine1']) {
            $data_toolbarLine1= 'data-toolbar1="' . $this->arguments['toolbarLine1'] . '"';
        } else {
            $data_toolbarLine1= '';
        }

        if ($this->arguments['toolbarLine2']) {
            $data_toolbarLine2= 'data-toolbar2="' . $this->arguments['toolbarLine2'] . '"';
        } else {
            $data_toolbarLine2= '';
        }

        if ($this->arguments['config'] && ($this->arguments['plugins'] || $this->arguments['toolbarLine1'] || $this->arguments['toolbarLine2'])) {
            // sinnvoll? TODO: config=userID  falls config=default d.h. falls kein Name angegeben ->Configurationen fuer ein Element
            $data_config= 'data-config="' . $this->arguments['config'] . '"';
        } else {
            $data_config= '';
        }
        $this->tag->addAttribute('data-toolbar2', $this->arguments['toolbarLine2']);

        return '<div class="dp-rte dp-rte-' . $this->arguments['config'] . ($this->hasError() ? $this->arguments['errorClass'] : '') . '" data-language="' . $lang . '" '.$data_plugins.' '.$data_toolbarLine1.' '.$data_toolbarLine2.' '. $data_config  .'>' . $this->tag->render() . '</div>';
    }
}
