<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;

//FormViewHelper
/**
 * SearchFormViewHelper
 */
class SearchFormViewHelper extends FormViewHelper
{
    /**
     * is it initialized? this is set to true, if the Repository::initAutoSorting($query) method is called
     * if false, a warning is displayed.
     */
    public static $isInitializedInQuery = false;

    /**
     * Base Class for the wrapper div
     * Override this to add searchform
     */
    protected $divBaseClass = ['dp-form', 'dp-searchform']; // , 'ym-grid'

    /**
     * Render the form.
     *
     * @return string rendered form
     */
    public function render(): string
    {
        /*if ($action == null) {
            $action = 'list';
            }*/

        $this->viewHelperVariableContainer->add(FormViewHelper::class, 'formClass', self::class);
        $ret = parent::render();
        //$action, $arguments, $controller, $extensionName, $pluginName, $pageUid, $object, $pageType, $noCache, $noCacheHash, $section, $format, $additionalParams, $absolute, $addQueryString, $argumentsToBeExcludedFromQueryString, $fieldNamePrefix, $actionUri, $objectName, $hiddenFieldClassName);
        $this->viewHelperVariableContainer->remove(FormViewHelper::class, 'formClass');
        return $ret;
    }

    /**
     * remove __referrer
     */
    protected function renderHiddenReferrerFields(): string
    {
        return '';
    }


    public function isSearchForm()
    {
        return true;
    }

    protected function getDefaultFieldNamePrefix(): string
    {
        return parent::getDefaultFieldNamePrefix() . '[@search]';
    }
}
