/**
 * Tabs
 */
IGDATAPOOLFE.plugins.add('tab', {
    form: null,
    init: function(form) {
	this.form = form;
	$tabPages = $('.dp-tabContainer .dp-tabPage', form);
	$tabHeaders = $('.dp-tabHeader', form);
	$tabDrawers = $('.dp-tabDrawer', form);

	if (form.classList.contains('dp-form-stepsform')) {
	    var $stepField = $('input.currentStep', form);

	    $tabHeaders.click(function(e) {
		$stepField.val($(this).data('rel'));
		$('form', form).submit();
	    });
	    $tabDrawers.click(function(e) {
		$stepField.val($(this).data('rel'));
		form.submit();
	    });

	    return;
	}

	$tabHeaders.click(function(e) {
	    e.preventDefault();
	    this.activateTab($(this));
	});
	$tabDrawers.click(function(e) {
	    e.preventDefault();
	    this.activateTab($(this));
	});

	//activate the first tab containing an error, or the first overall tab
	var $tabToActivate = $tabHeaders.filter('.dp-tabHeader-error:first');
	if ($tabToActivate.length == 0)
	    $tabToActivate = $tabHeaders.filter(':first');
	this.activateTab($tabToActivate);

    },
    activateTab: function($someTabHeader) {
	var tabNumber = $someTabHeader.data('rel');
	//header remove all active classes
	$tabHeaders.removeClass('dp-tabHeader-active');
	$tabDrawers.removeClass('dp-tabDrawer-active');
	// acrivate current
	$tabHeaders.filter('.dp-tabHeader-' + tabNumber).addClass('dp-tabHeader-active');
	$tabDrawers.filter('.dp-tabDrawer-' + tabNumber).addClass('dp-tabDrawer-active');

	//content
	$tabPages.hide().filter($someTabHeader.children('a').attr('href')).show();
	this.form.dispatchEvent(new Event('tab_changed'));
	//this.form.trigger('tab_changed');
    },
    /**
     * File Upload Language Pulldown
     */
    initLanguageFileUpload: function() {
	$('.dp-file-upload-lang-select', this.form).each(function() {
	    $(this).on('change', function() {
		if($(this).val()=='') {
		    $(this).next('.dp-file-upload-lang-upload').show();
		}else {
		    $(this).next('.dp-file-upload-lang-upload').hide();
		}
		if($('option:selected', $(this)).attr('class')=='dp-no' ) {
		    $('textarea', $(this).parentsUntil('.dp-generalinline-innerrow')).prop( "disabled", true );
		}else {
		    $('textarea', $(this).parentsUntil('.dp-generalinline-innerrow')).prop( "disabled", false );
		}
            });
	    //alert('c=' + $('option:selected', $(this)).attr('class') + ', V=' + $('option:selected', $(this)).is(":visible"));
	    if($('option:selected', $(this)).attr('class')=='dp-no' && $('option:selected', $(this)).is(":visible") ) { //TODO ist nie dargestellt -> ist in Tab
		$('textarea', $(this).parentsUntil('.dp-generalinline-innerrow')).prop( "disabled", true );
	    }

	});

        $('.dp-sorting-up', this.form).each(function() {
            $(this).on('click', function() {
                // if ($el.not(':first-child'))
                var $el = $(this).parent().parent().parent();
                //'.dp-generalinline-record');

                var $el_cur_sort = $('input.dp-file-upload-sort', $el).val();
                var $el_prev_sort = $('input.dp-file-upload-sort', $el.prev()).val();
                $('input.dp-file-upload-sort', $el).val($el_prev_sort);
                $('input.dp-file-upload-sort', $el.prev()).val($el_cur_sort);

                $el.prev().before($el);
                //tinymce.remove();
                this.form.initFields($el.get());
            });
        });


        $('.dp-sorting-down', this.form).each(function() {
            $(this).on('click', function() {
                // if ($el.not(':last-child'))
                var $el = $(this).parent().parent().parent();
                //'.dp-generalinline-record');
                var $el_cur_sort = $('input.dp-file-upload-sort', $el).val();
                var $el_next_sort = $('input.dp-file-upload-sort', $el.next()).val();
                $('input.dp-file-upload-sort', $el).val($el_next_sort);
                $('input.dp-file-upload-sort', $el.next()).val($el_cur_sort);

                $el.next().after($el);
                //tinymce.remove();
                this.form.initFields($el.get());
            });
        });

    } 

});
