    IGDATAPOOLFE = {};
    IGDATAPOOLFE.resourceManager = function (basepath, name) {
	this.basePath=basepath;
	this.fileName=name;
	this.registered={};
	this.loaded={};
    };
    IGDATAPOOLFE.resourceManager.prototype = {
	add: function(name, filename){
	    if(this.registered[name]) {
		throw Error('[IGDATAPOOLFE.resourceManager.add] The resource name "' + name + '" is already registered.');
	    } else {
		this.registered[name] = filename;
		this.load(name, filename);
	    }
	},
	listRegistered: function() {
	    console.log(this.registered);
	},
	listLoaded: function() {
	    console.log(this.loaded);
	},
	load: function(name, src) {
	    path = this.basePath + src;
	    const script = document.createElement('script');
	    script.id = name;
	    script.src = window.location.origin + path;
	    script.async = true;
	    console.log('load=' + path);
	    script.onload = function() {
		//console.log('loaded');
		IGDATAPOOLFE.resourceManager.loaded[this.id] = this;
		IGDATAPOOLFE.plugins.listLoaded();
	    }
	}
    };
    
