/**
 * Easypick Fields, aka the new date picker
 */
IGDATAPOOLFE.plugins.add('easepickField', {
    form: null,
    initFields: function(form) {
	    this.init(form);
    },
    init: function(form) {
	    this.form = form;

        var pickerElements = form.querySelectorAll('.dp-easepick');
        var minDate = (new easepick.DateTime()).clone().subtract(10 * 12, 'month');
        var maxDate = (new easepick.DateTime()).clone().add(20 * 12, 'month');
        var pickers = [];
        pickerElements.forEach(function(element) {
	        var options = JSON.parse(element.dataset.dateoptions);
            options.element = element;
            options.lang = document.querySelector('html').lang;
            element.value = element.dataset.value;

            options.plugins = [
                "AmpPlugin",
                "LockPlugin"
            ];
            if(!options.format) {
                options.format = 'DD.MM.YYYY';
            }
            if(!options.formatSubmit) {
                options.format = 'YYYY-MM-DD';
            }
            if(options.minDate) {
                minDate = new easepick.DateTime(options.minDate);
            }
            if(options.maxDate) {
                maxDate = new easepick.DateTime(options.maxDate);
            }

            var selectYears = false;
            if(options.selectYears) {
                selectYears = options.selectYears;
            }

            var selectMonths = false;
            if(options.selectMonths) {
                selectMonths = options.selectMonths;
            }

            var showClear = true;
            if(options.showClear) {
                showClear = options.showClear;
            }

            var submitOnChange = false;
            if(element.dataset.submit) {
                submitOnChange = true;
            }
            options.autoApply = submitOnChange;

            if(!options.AmpPlugin) {
                options.AmpPlugin = {
                    dropdown: {
                        months: selectMonths,
                        years: selectYears,
                    },
                    resetButton: showClear,
                    darkMode: false
                };
            }
            
            if(!options.LockPlugin) {
                options.LockPlugin = {};
            }
            if(minDate || maxDate) {
                if(minDate) {
                    options.LockPlugin.minDate = minDate.format(options.format);
                    if(options.AmpPlugin) {
                        options.AmpPlugin.dropdown.minYear = minDate.format('YYYY');
                    }
                };
                if(maxDate) {
                    options.LockPlugin.maxDate = maxDate.format(options.format);
                    if(options.AmpPlugin) {
                        options.AmpPlugin.dropdown.maxYear = maxDate.format('YYYY');
                    }
                }
            }

            if(!options.css) {
                options.css = [
                    "/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/easepick/easepick.css",
                    "/typo3conf/ext/ig_datapool_fe/Resources/Public/Css/easepick.css"
                ];
            }
            if(!options.zIndex) {
                options.zIndex = 10;
            }
            pickers.push(new easepick.create(options));
        });
        form.addEventListener('submit', function(e) {
            pickers.forEach(function(picker) {
                var element = picker.options.element;
                var value = element.value;
                var date = picker.getDate();
                if(value && date && picker.options.formatSubmit) {
                    element.value = date.format(picker.options.formatSubmit);
                }
            });
        });
    }
});