<?php

declare(strict_types=1);

use TYPO3\CMS\Core\Information\Typo3Version;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\HtmlConverter;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileReferenceConverter;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\ObjectStorageConverter;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\FileConverter;
use Internetgalerie\IgDatapoolFe\Controller\AjaxUploadController;
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;

//use Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter;
//use TYPO3\CMS\Extbase\Utility\ExtensionUtility;

defined('TYPO3') or die();


if ((new Typo3Version())->getMajorVersion() < 12)
{

    /**
     * DateTime Converter for dates without seconds
     */
    ExtensionUtility::registerTypeConverter(DateTimeConverter::class);

   ExtensionUtility::registerTypeConverter(HtmlConverter::class);

    /**
     * Type Converter for FileReferences
     */
    ExtensionUtility::registerTypeConverter(FileReferenceConverter::class);

    /**
     * Type Converter for ObjectStorage: does not store NULL
     */
    ExtensionUtility::registerTypeConverter(ObjectStorageConverter::class);


    /**
     * Type Converter for File
     */
    ExtensionUtility::registerTypeConverter(FileConverter::class);
}

ExtensionUtility::configurePlugin(
    // extension name, matching the PHP namespaces (but without the vendor)
    'IgDatapoolFe',
    // arbitrary, but unique plugin name (not visible in the backend)
    'AjaxUpload',
    // all actions
    [AjaxUploadController::class => 'ajaxUpload'],
    // non-cacheable actions
    [AjaxUploadController::class => 'ajaxUpload'],
);
