<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use TYPO3\CMS\Fluid\ViewHelpers\Form\AbstractFormFieldViewHelper;
use DateTime;
use Internetgalerie\IgDatapoolFe\Services\LangService;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * View Helper which creates a text field (<input type="text">).
 *
 * = Examples =
 *
 * <code title="Example">
 * <f:form.textfield name="myTextBox" value="default value" />
 * </code>
 * <output>
 * <input type="text" name="myTextBox" value="default value" />
 * </output>
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class DateSelectViewHelper extends AbstractFormFieldViewHelper implements FieldInterface
{
    use FormFieldTrait;
    //use FieldTrait;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('yearRange', 'string', 'Range of the Year-Selectbox', false, '');
        $this->registerArgument('relativeYears', 'string', 'relative range of the year selectbox', false, '10,10');
        $this->registerArgument('default', 'string', 'Default Value');
    }

    /**
     * Renders the date selectbox.
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        $name = $this->getName();
        //is this neccessary?
        $this->registerFieldNameForFormTokenGeneration($name);

        $curDay = $curMonth = $curYear = '';
        $curDate = $this->getValueAttribute();

        if (is_string($curDate)) {
            $curDate = DateTime::createFromFormat('d.m.Y', $curDate);
        }
        //intenionally no else
        if ($curDate instanceof DateTime) {
            $curDay = $curDate->format('d');
            $curMonth = $curDate->format('m');
            $curYear = $curDate->format('Y');
        } elseif (is_array($curDate)) {
            $curDay = $curDate['d'];
            $curMonth = $curDate['m'];
            $curYear = $curDate['Y'];
        }

        $op = ['<option disabled="disabled" value="">' . LangService::ll('field.date.day', 'ig_datapool_fe', $this->arguments['property']) . '</option>'];
        for ($i = 1; $i <= 31; $i++) {
            $op[] = '<option ' . ($curDay == $i ? 'selected="selected"' : '') . '>' . $i . '</option>';
        }
        $d = '<select ' . ($this->hasError() ? 'class ="' . $this->arguments['errorClass'] . '"' : '') . ' name="' . $name . '[day]">' . implode('', $op) . '</select>';

        $op = ['<option disabled="disabled" value="">' . LangService::ll('field.date.month', 'ig_datapool_fe', $this->arguments['property']) . '</option>'];
        for ($i = 1; $i <= 12; $i++) {
            $op[] = '<option  value="' . $i . '" ' . ($curMonth == $i ? 'selected="selected"' : '') . '>' . strftime('%B', mktime(1, 0, 0, $i, 1, 2010)) . '</option>';
        }
        $m = '<select ' . ($this->hasError() ? 'class ="' . $this->arguments['errorClass'] . '"' : '') . ' name="' . $name . '[month]">' . implode('', $op) . '</select>';

        $op = ['<option disabled="disabled" value="">' . LangService::ll('field.date.year', 'ig_datapool_fe', $this->arguments['property']) . '</option>'];

        $end = $start = strftime('%Y');
        if ($this->hasArgument('yearRange') && $this->arguments['yearRange']) {
            $res = GeneralUtility::trimExplode(',', $this->arguments['yearRange'], true);
            $start = $res[0];
            $end = $res[1];
        } elseif ($this->hasArgument('relativeYears') && $this->arguments['relativeYears']) {
            $rel = GeneralUtility::trimExplode(',', $this->arguments['relativeYears'], true);
            if (count($rel) == 2) {
                $rel1 = $rel[0];
                $rel2 = $rel[1];
            } else {
                $rel1 = $rel2 = $rel[0];
            }
            $start -= $rel1;
            $end += $rel2;
        }
        for ($i = $start; $i <= $end; $i++) {
            $op[] = '<option value="' . $i . '" ' . ($curYear == $i ? 'selected="selected"' : '') . '>' . $i . '</option>';
        }

        $y = '<select ' . ($this->hasError() ? 'class ="' . $this->arguments['errorClass'] . '"' : '') . ' name="' . $name . '[year]">' . implode('', $op) . '</select>';
        $f = '<input type="hidden" name="' . $name . '[dateFormat]" value="Y-m-d" />';
        $out = '<div class="dp-dateSelect">' . $d . $m . $y . $f . '</div>';
        return $out;
    }
}
