/**
 * CKEDITOR RTE
 */
import {
    ClassicEditor,
    Essentials,
    Paragraph,
    Bold,
    Italic,
    Underline,
    Strikethrough,
    Subscript,
    Superscript,
    SpecialCharacters,
    SpecialCharactersEssentials,
    
    Font,
    Heading,
    List,
    Table,
    Link,
    Alignment,
    Indent,
    HorizontalLine,
    Clipboard,
    GeneralHtmlSupport,
    PastePlainText,
    PasteFromOffice,
    RemoveFormat,
    SourceEditing,
} from 'ckeditor5';

IGDATAPOOLFE.ckeditors = {};
IGDATAPOOLFE.plugins.add('ckeditor', {
    form: null,
    initFields: function(form) {
	this.init(form);
    },
    init: function(form) {
	this.form = form;
	document.querySelectorAll('.dp-ckeditor textarea').forEach(function(el) {
	    if(!el.closest('.dp-inlinerecord-container-new')) {
		var id = el.id;
		var config = null;
		var ckeditor = el.closest('.dp-ckeditor');
		var language = ckeditor.getAttribute('data-language');

		if(ckeditor.getAttribute('data-config')) {
		    config = JSON.parse(ckeditor.getAttribute('data-config'));
		    config.plugins = [ Essentials, Paragraph, Bold, Italic, Underline, Strikethrough, Subscript, Superscript, SpecialCharacters, SpecialCharactersEssentials, Font, Heading, List, Table, Link, Alignment, Indent, HorizontalLine, Clipboard, GeneralHtmlSupport, PastePlainText, PasteFromOffice, RemoveFormat, SourceEditing ];
		    //config.translations = [coreTranslations];
		} else {
		    config ={}
		}
		import(`ckeditor5/translations/${language}.js`).then(coreTranslations => {
		    console.log(coreTranslations);
		    config.translations = [coreTranslations.default || coreTranslations]; // Handle default export if necessary
		    
		    ClassicEditor
			.create( document.getElementById(id), config)
			.then( editor => {
			    IGDATAPOOLFE.ckeditors[ id ] = editor;
			});
		});
	    }
	});
    }
});