<?php

namespace Internetgalerie\IgDatapoolFe\Services;

use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class LangService implements SingletonInterface
{
    /**
     * public call and singleton interface for tranlsate method
     *
     * @see translate()
     */
    public static function ll($path, $extName = 'extbase', $specialContext = 'main', $arguments = [])
    {
        return self::getInstance()->translate($path, $extName, $specialContext, $arguments);
    }

    public static $instance = null;

    public static function getInstance()
    {
        if (self::$instance == null) {

            // SH: self::$instance = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\Internetgalerie\IgDatapoolFe\Services\LangService::class);
            self::$instance = GeneralUtility::makeInstance(\Internetgalerie\IgDatapoolFe\Services\LangService::class);
        }
        return self::$instance;
    }

    protected $currentLabels = [];

    protected $currentExtension = '';

    /**
     * translaton utilty
     * get defaults from:
     * 1. custom labels
     * 2. current extension,
     * 3. ig datapool fe
     * 4. extbase or given name
     */
    public function translate($path, $extName = '', $specialContext = '', $arguments = [])
    {
        if ($specialContext == '') {
            $specialContext = 'main';
        }
        $out = '';

        // 1. custom label set
        $newPathOrLabel = $this->currentLabels[$specialContext][$path] ?? '';

        // 1.5 main context
        if (!$newPathOrLabel) {
            $newPathOrLabel = $this->currentLabels['main'][$path] ?? '';
        }

        if ($newPathOrLabel) {
            //try to find a label in the current extension LLL, set it if it exists
            if ($this->currentExtension && ($label = LocalizationUtility::translate($newPathOrLabel, $this->currentExtension, $arguments))) {
                $out = $label;
            } else {
                $out = $newPathOrLabel;
            }
        }
        if ($out) {
            return $out;
        }
        if ($this->currentExtension) {
            // 2. try current extension
            $out = LocalizationUtility::translate($path, $this->currentExtension, $arguments);
            if ($out) {
                return $out;
            }
        }

        // 3. try ig_render
        $out = LocalizationUtility::translate($path, 'igRender', $arguments);
        if ($out) {
            return $out;
        }

        //4. try original
        return LocalizationUtility::translate($path, $extName ?: 'extbase', $arguments);
    }

    /**
     * Set a label for a custom field or overall for the current action
     */
    public function setLabel($path, $newPathOrLabel, $specialContext = 'main'): void
    {
        $this->currentLabels[$specialContext][$path] = $newPathOrLabel;
    }

    /**
     * initialize the langservice by setting the current extension
     */
    public function setCurrentExtension($extKey): void
    {
        $this->currentExtension = $extKey;
    }
}
