<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

/**
 * Creates a Form Tab-Navigation based on the inner Tabs
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class FieldsetViewHelper extends AbstractAggregateViewHelper
{
    /**
     * Fiedset Title
     *
     * @var string
     */
    protected $title = '';
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('title', 'string', 'The title of the Fieldset.', false, '');
    }

    public function render(): string
    {
        parent::render();
        $content = $this->renderAggregateChildren();

        $out = '';
        if ($this->hasArgument('title')) {
            $this->title = $this->arguments['title'];
            $out .= '<div class="dp-legend ' . ($this->hasError() ? 'dp-legend-error' : '') . '">' . htmlspecialchars((string) $this->title) . '</div>';
        }

        $out .= '
<fieldset class="dp-fieldset ' . ($this->hasError() ? 'dp-fieldset-error' : '') . '">
	<legend>' . htmlspecialchars($this->title) . '</legend>';
        $out .= $content;
        $out .= '
</fieldset>';

        return $out;
    }
}
