<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

/**
 * Renders an <input type="hidden" ...> tag.
 *
 * = Examples =
 *
 * <code title="Example">
 * <f:form.hidden name="myHiddenValue" value="42" />
 * </code>
 * <output>
 * <input type="hidden" name="myHiddenValue" value="42" />
 * </output>
 *
 * You can also use the "property" attribute if you have bound an object to the form.
 * See <f:form> for more documentation.
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class HiddenViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\HiddenViewHelper implements FieldInterface
{
    use FormFieldTrait;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('default', 'string', 'Default Value');
    }
    //    use FieldTrait;
}
