<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Slider\Range;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IfSetViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('value', 'mixed', 'form value', true);
        $this -> registerArgument('min', 'float', 'min', false, 0);
        $this -> registerArgument('max', 'float', 'max', false, 100);
        $this -> registerArgument('step', 'float', 'step', false, 0);
    }


    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $min = $arguments['min'];
        $max = $arguments['max'];
        $step = $arguments['step'];
        $value = $arguments['value'];
        if (is_array($value)) {
            $fromValue = $value['from'] ?? $min;
            $toValue = $value['to'] ?? $max;
        } else {
            $v = explode(',', (string) $value);
            $fromValue = $v[0] ?? $min;
            $toValue = $v[1] ?? $max;
        }
        return !($min==$fromValue && $max==$toValue);
    }
}
