<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Widget\Controller;

use TYPO3\CMS\Extbase\Mvc\View\ViewInterface;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

/*                                                                        *
 * This script is backported from the TYPO3 Flow package "TYPO3.Fluid".   *
 *                                                                        *
 * It is free software; you can redistribute it and/or modify it under    *
 * the terms of the GNU Lesser General Public License, either version 3   *
 *  of the License, or (at your option) any later version.                *
 *                                                                        *
 *                                                                        *
 * This script is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-    *
 * TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser       *
 * General Public License for more details.                               *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with the script.                                         *
 * If not, see http://www.gnu.org/licenses/lgpl.html                      *
 *                                                                        *
 * The TYPO3 project - inspiring people to share!                         *
 *                                                                        */
/**
 * Renders a pagebrowser
 *
 * MB: Extened from \TYPO3\CMS\Fluid\ViewHelpers\Widget\Controller\PaginateController.
 * Modified so we can use the pagenumber in the list.
 */
class PaginateController extends \TYPO3\CMS\Fluid\ViewHelpers\Widget\Controller\PaginateController
{
    protected $parentRequest;

    public function setParentRequest($request): void
    {
        $this->parentRequest = $request;
    }

    /**
     *
     * @param  integer $currentPage
     * @return void
     */
    public function indexAction($currentPage = 1): void
    {

        // set current page
        $this->currentPage = intval($currentPage);
        if ($this->currentPage < 1) {
            $this->currentPage = 1;
        }


        /*
            if ($this->currentPage > $this->numberOfPages) {
                // set $modifiedObjects to NULL if the page does not exist
                $modifiedObjects = NULL;
            } else {
                // modify query
                $itemsPerPage = intval($this->configuration['itemsPerPage']);
                $query = $this->objects->getQuery();
                $query->setLimit($itemsPerPage);
                if ($this->currentPage > 1) {
                    $query->setOffset(intval($itemsPerPage * ($this->currentPage - 1)));
                }
                $modifiedObjects = $query->execute();
            }

            $pargination = $this->buildPagination();

             // EDIT MB:
            $this->view->assign('contentArguments', array($this->widgetConfiguration['as'] => $modifiedObjects, 'pagination' => $pargination));
        /*
        // END EDIT MB
             */


        if ($this->currentPage > $this->numberOfPages) {
            $this->currentPage = $this->numberOfPages;
        }
        $pargination = $this ->buildPagination();

        $itemsPerPage = intval($this ->configuration['itemsPerPage']);
        $itemsStart = $itemsPerPage * ($this ->currentPage - 1);
        if (is_array($this ->objects)) {
            $itemsCount=count($this ->objects);
            $objects=[];
            for ($i=$itemsStart;$i<$itemsStart+$itemsPerPage;$i++) {
                if (isset($this->objects[$i])) {
                    $objects[]=$this->objects[$i];
                }
            }
            $this ->view ->assign('contentArguments', [$this ->widgetConfiguration['as'] => $objects, 'pagination' => $pargination]);
        } else {
            $itemsCount=$this ->objects->count();
            /*
            // langsaaaaaaaaaaaaaammmmmmmmmmmmmmmmmmmmmmmm
            for($i=0;$i<$itemsStart;$i++) {
            $this ->objects->offsetUnset($i);
            }
            for($i=$itemsStart+$itemsPerPage;$i<$itemsCount;$i++) {
            $this ->objects->offsetUnset($i);
            }
            $this ->view ->assign('contentArguments', array($this ->widgetConfiguration['as'] => $this ->objects, 'pagination' => $pargination));

            */
            $objects=[];
            for ($i=$itemsStart;$i<$itemsStart+$itemsPerPage;$i++) {
                if (isset($this->objects[$i])) {
                    $objects[]=$this ->objects->offsetGet($i);
                }//$this->objects[$i];
            }
            $this ->view ->assign('contentArguments', [$this ->widgetConfiguration['as'] => $objects, 'pagination' => $pargination]);
            //echo($itemsPerPage . '/'.$itemsStart . 'von '. $itemsCount);
        }


        $this->view->assign('configuration', $this->configuration);
        $this->view->assign('pagination', $pargination);
    }

    /**
     * Allows the widget template root path to be overriden via the framework configuration,
     * e.g. plugin.tx_extension.view.widget.<WidgetViewHelperClassName>.templateRootPath
     *
     * @param  \TYPO3\CMS\Extbase\Mvc\View\ViewInterface $view
     * @return void
     */
    protected function setViewConfiguration(ViewInterface $view)
    {
        $rootPath = ExtensionManagementUtility::extPath($this->parentRequest->getControllerExtensionKey());
        $templatePathAndFilename = $rootPath . 'Resources/Private/Partials/' . $this->parentRequest->getControllerName() . '/PageBrowser.html';
        if (!file_exists($templatePathAndFilename)) {
            $templatePathAndFilename = $rootPath . 'Resources/Private/Partials/PageBrowser.html';
        }
        $view->setTemplatePathAndFilename($templatePathAndFilename);
    }
}
