/**
 * Easypick Fields, aka the new date picker
 */
IGDATAPOOLFE.plugins.add('easepickTimeField', {
    form: null,
    initFields: function(form) {
	    this.init(form);
    },
    init: function(form) {
        function getTimePart(timePart) {
            var value = '';
            if(String(timePart).length == 1) {
                value += '0' + String(timePart);
            } else {
                value += String(timePart);
            }

            return value;
        }
        
	    this.form = form;

        var pickerElements = form.querySelectorAll('.dp-easepick-time');

        pickerElements.forEach(function(element) {
	        var options = JSON.parse(element.dataset.dateoptions);
            var value = element.dataset.value;
            element.dataset.value = '';
            element.value = '';

            options.element = element;
            options.lang = document.querySelector('html').lang;
            options.autoApply = false;
            options.calendars = 0;
            options.setup = function(picker) {
                picker.on('render', function(e) {
                    var applyButton = picker.ui.shadowRoot.querySelector('.time-plugin .apply-button');
                    if(applyButton) {
                        applyButton.disabled = false;
                        
                        var resetButton = picker.ui.shadowRoot.querySelector('.time-plugin .reset-button');

                        if(!resetButton) {
                            resetButton = document.createElement('button');
                            resetButton.classList.add('reset-button');
                            resetButton.classList.add('unit');
                            resetButton.innerHTML = 'Reset';
                            applyButton.parentNode.insertBefore(resetButton, applyButton);
                            resetButton.addEventListener('click', function(e) {
                                element.dataset.value = '';
                                element.value = '';
                                value = '';
                                picker.ui.shadowRoot.querySelector('.container').classList.remove('show');
                            })
                        }
                    }
                    if(value) {
                        var valSplit = value.split(':');
                        output = '';
                        for(var i = 0; i < valSplit.length; i++) {
                            if(i > 0) {
                                output += ':';
                            }
                            output += getTimePart(valSplit[i]);
                        }
                        element.dataset.value = output;
                        element.value = output;
                        value = output;
                    }
                });
                picker.on('select', function(e) {
                    var selects = picker.ui.shadowRoot.querySelectorAll('.time-plugin-custom-input');
                    var i = 0;
                    var output = '';
                    selects.forEach(function(selectElement) {
                        if(i > 0) {
                            output += ':';
                        }
                        output += getTimePart(selectElement.value);
                        i++;
                    });
                    element.dataset.value = output;
                    element.value = output;
                });
            };
            options.plugins = [
                "AmpPlugin",
                "TimePlugin"
            ];

            options.AmpPlugin = {
                resetButton: true,
                darkMode: false
            };
            options.TimePlugin = {
                format: 'HH:mm'
            };
            if(!options.format) {
                options.format = 'hh:mm';
            }
            if(!options.css) {
                options.css = [
                    "/typo3conf/ext/ig_datapool_fe/Resources/Public/JavaScript/easepick/easepick.css",
                    "/typo3conf/ext/ig_datapool_fe/Resources/Public/Css/easepick.css"
                ];
            }
            if(!options.zIndex) {
                options.zIndex = 10;
            }
            var picker = new easepick.create(options);
        });
    }
});