<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

/**
 * Renders an ajaax uploader
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class ImageUploadViewHelper extends UploadViewHelper
{
    use FormFieldTrait;
    //use FieldTrait;

    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        global $TYPO3_CONF_VARS;
        parent::initializeArguments();
        $this -> overrideArgument('allowedFileExt', 'string', 'List of allowed file types', false, $TYPO3_CONF_VARS['GFX']['imagefile_ext']);
        $this -> overrideArgument('acceptMimeTypes', 'string', 'Mime Types, i.e. images/*. only these will be shown in the upload selector. accept="" attrib. see http://www.iana.org/assignments/media-types/media-types.xhtml.', false, 'image/*');
        $this -> registerArgument('minImageSize', 'string', 'Minimal image size in Megapixel, i.e. 2mp');
    }
}
