<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form\Select;

use Internetgalerie\IgDatapoolFe\ViewHelpers\Form\SelectViewHelper;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class MultipleSideBySideViewHelper extends SelectViewHelper
{
    protected $availableStringDuallistboxSettings = ['nonSelectedListLabel', 'selectedListLabel', 'filterPlaceHolder', 'filterTextClear', 'moveSelectedLabel' ,'moveAllLabel', 'removeAllLabel', 'infoText', 'infoTextFiltered', 'infoTextEmpty'];
    protected $availableBooleanDuallistboxSettings = ['showFilterInputs'];
    protected $availableIntegerDuallistboxSettings = ['selectorMinimalHeight'];
    protected PageRenderer $pageRenderer;

    public function injectPageRenderer(PageRenderer $pageRenderer): void
    {
        $this->pageRenderer = $pageRenderer;
    }

    /**
     * Initialize arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('columns', 'integer', 'columns', false, 1);
        $this -> registerArgument('search', 'integer', 'search', false, false);
        $this -> registerArgument('selectAll', 'integer', 'selectAll', false, false);
        foreach ($this->availableStringDuallistboxSettings as $name) {
            $this -> registerArgument($name, 'string', $nam, false);
        }
        foreach ($this->availableBooleanDuallistboxSettings as $name) {
            $this -> registerArgument($name, 'bool', $nam, false);
        }
        foreach ($this->availableIntegerDuallistboxSettings as $name) {
            $this -> registerArgument($name, 'int', $nam, false);
        }
    }


    public function render(): string
    {
        $this->pageRenderer->addJsFooterLibrary('multiselect', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/bootstrap-duallistbox-master/dist/jquery.bootstrap-duallistbox.min.js');
        $this->pageRenderer->addJsFooterLibrary('multiselect-init', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/bootstrap-duallistbox-master/dist/bootstrap-duallistbox-init.js');
        $this->pageRenderer->addCssFile('EXT:ig_datapool_fe/Resources/Public/JavaScript/bootstrap-duallistbox-master/dist/bootstrap-duallistbox.css');

        $class= 'dp-select-duallistbox';

        if ($this->tag->hasAttribute('class')) {
            $class .= ' ' . $this->tag->getAttribute('class');
        }
        $this->tag->addAttribute('class', $class);
        $this->arguments['class']= $class;
        $duallistboxSettings= [];
        foreach ($this->availableStringDuallistboxSettings as $name) {
            if (isset($this->arguments[$name])) {
                $duallistboxSettings[$name] = $this->arguments[$name];
            }
        }
        foreach ($this->availableBooleanDuallistboxSettings as $name) {
            if (isset($this->arguments[$name])) {
                $duallistboxSettings[$name] = (bool) $this->arguments[$name];
            }
        }
        foreach ($this->availableIntegerDuallistboxSettings as $name) {
            if (isset($this->arguments[$name])) {
                $duallistboxSettings[$name] = (int) $this->arguments[$name];
            }
        }
        $this->tag->addAttribute('data-duallistbox-settings', json_encode($duallistboxSettings));

        return  parent::render();
    }
}
