<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\TextfieldViewHelper;

/**
 * Renders a spinner next to the input text field.
 *
 * = Examples =
 *
 * <code title="Example">
 * <dp:form.spinner property="name2" min="0" max="10" step="1"   />
 * </code>
 *
 * You can also use the "property" attribute if you have bound an object to the form.
 * See <f:form> for more documentation.
 */
class SpinnerViewHelper extends TextfieldViewHelper
{
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('min', 'int', 'Minimum Value', false);
        $this->registerArgument('max', 'int', 'Maximum Value', false);
        $this->registerArgument('step', 'float', 'Step', false, 1);
        //$this->registerArgument('default', 'mixed', 'Default Value');
        //$this->registerUniversalTagAttributes();
    }

    /**
     * Renders the hidden field.
     *
     * @return string
     * @api
     */
    public function render(): string
    {
        if (isset($this->arguments['min'])) {
            $this->tag->addAttribute('data-min', intval($this->arguments['min']));
        }
        if (isset($this->arguments['max'])) {
            $this->tag->addAttribute('data-max', intval($this->arguments['max']));
        }
        $this->tag->addAttribute('data-step', ($this->arguments['step']));


        $field = parent::render();

        return '<div class="dp-spinner">' . $field . '</div>';
    }
}
