<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers\Form;

use Internetgalerie\IgDatapoolFe\ViewHelpers\SearchFormViewHelper;
use Internetgalerie\IgDatapoolFe\Services\LangService;
use TYPO3\CMS\Fluid\ViewHelpers\FormViewHelper;

/**
 * Creates a submit button.
 *
 * = Examples =
 *
 * <code title="Defaults">
 * <f:form.submit value="Send Mail" />
 * </code>
 * <output>
 * <input type="submit" />
 * </output>
 *
 * <code title="Dummy content for template preview">
 * <f:submit name="mySubmit" value="Send Mail"><button>dummy button</button></f:submit>
 * </code>
 * <output>
 * <input type="submit" name="mySubmit" value="Send Mail" />
 * </output>
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class SubmitViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Form\SubmitViewHelper implements FieldInterface
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->overrideArgument('class', 'string', 'CSS Class', false, 'dp-button-important');
    }

    // Combat
    /*
        protected function getValue($convertObjects = TRUE) {
      return $this->getValueAttribute( $convertObjects );
    }
    */
    /**
     * This overrides the traits getValueAttribute Method!
     */
    protected function getValueAttribute($convertObjects = true)
    {
        if ($this->hasArgument('value')) {
            return $this->arguments['value'];
        }

        $formClass='';
        if ($this->viewHelperVariableContainer->exists(FormViewHelper::class, 'formClass')) {
            $formClass = $this->viewHelperVariableContainer->get(FormViewHelper::class, 'formClass');
        }
        if ($formClass==SearchFormViewHelper::class) {
            return LangService::ll('list.search', 'ig_datapool_fe');
        } else {
            return LangService::ll('label.submit', 'ig_datapool_fe');
        }
    }

    protected function getName(): string
    {
        if ($this->hasArgument('name')) {
            return $this->arguments['name'];
        }
        return $this->prefixFieldname('dp-submit-button');
    }
}
