<?php

namespace Internetgalerie\IgDatapoolFe\ViewHelpers;

use TYPO3\CMS\Core\Page\AssetCollector;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * Creates an InfoBubble
 *
 * @api
 * @author     Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package    IgDatapoolFE
 * @subpackage ViewHelpers
 */
class InfoBubbleViewHelper extends AbstractViewHelper
{
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('text', 'string', 'Tooltip Text.', true, '');
        $this->registerArgument('style', 'int', 'Style', false, '0');
    }

    /**
     * Renders a tooltip element
     *
     * @return string
     */
    public function render()
    {
        $assetCollector = GeneralUtility::makeInstance(AssetCollector::class);
        $assetCollector->addStyleSheet('ig_datapool_fe_tooltipster', 'EXT:ig_datapool_fe/Resources/Public/Css/tooltipster.css');
        $assetCollector->addJavaScript('ig_datapool_fe_tooltipster', 'EXT:ig_datapool_fe/Resources/Public/JavaScript/jquery.tooltipster.js');
         $child = $this->renderChildren();

        // is it a div with content or just a button
        if (trim((string) $child) == '') {
            $class = 'dp-infobubble-button';
            $child = '&nbsp;';
        } else {
            $class = 'dp-infobubble-div';
        }
        // add a style
        $styleClass = 'dp-infobubble-style' . $this->arguments['style'];
        $out = '<div class="' . $class . ' ' . $styleClass . '" data-infobubble="' . htmlspecialchars((string) $this->arguments['text']) . '" >' . $child . '</div>';
        return $out;
    }
}
