<?php

namespace Internetgalerie\IgDatapoolFe\Property\TypeConverter;

use TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface;
use TYPO3\CMS\Extbase\Property\TypeConverter\AbstractTypeConverter;

class TimeIntegerConverter extends AbstractTypeConverter
{
    /**
     * @var array<string>
     */
    protected $sourceTypes = ['string'];

    /**
     * @var string
     */
    protected $targetType = 'int';



    protected $priority = 1;

    public function convertFrom($source, string $targetType, array $convertedChildProperties = [], PropertyMappingConfigurationInterface $configuration = null): ?int
    {
        if ($source === null || $source == '') {
            return null;
        }
        $hms = explode(':', (string) $source);
        if (count($hms) == 2) {
            return ($hms[0] * 60 + $hms[1]) * 60;
        }
        if (count($hms) == 3) {
            return ($hms[0] * 60 + $hms[1]) * 60 + $hms[2];
        }
        return null;
    }
}
