/**
 * Password
 */
IGDATAPOOLFE.plugins.add('passwordStrengthMeter', {
    form: null,
    initFields: function(form) {
	this.init(form);
    },
    init: function(form) {
	let $form = $(form);
	this.form = $form;
	/**
	 * entropy bits:
	 * < 28 tooweak
	 * 35: weak
	 * 59: strong
	 * >60: very strong, financial
	 */

	$('.dp-password-indicator', $form).each(function() {
	    var $this = $(this);
	    var $indicator = $('div.dp-indicator', $this);
	    var entropy = $this.data('entropy');
	    var labels = $this.data('labels');
	    $('input[type=password]', $this).keyup(function() {
		var w = $(this).val();

		var s2 = getPasswordStrength(w);

		var percentage = 0;
		var colorR = 255, colorG = 0, colorB = 0;
		percentage = Math.max(0, Math.min(1.0, Math.min((s2 - entropy.min) / entropy.max, 100)));

		colorR = Math.floor(Math.min(255, 510 - percentage * 255 * 2));
		colorG = Math.floor(Math.min(percentage * 255 * 2, 255));
		colorB = 0;
		var rgb = 'rgb(' + colorR + ',' + colorG + ',0)';
		var label_id = Math.floor(percentage / (1 / (labels.length )));

		$indicator.text(labels[label_id]);
		$indicator.attr('class', 'dp-indicator').css('width', percentage * 100 + '%').css('background-color', rgb).css('opacity', 0.8);
	    });
	});

    }
});