Math.log10 = Math.log10 || function(x) {
  return Math.log(x) * Math.LOG10E;
};
$('.dp-slider-range-slider').each(function() {
    var currentSlider = this;
    var currentSliderContainer = $(currentSlider).parents('.dp-slider-range');
    var inputFromNumber = $('.dp-slider-range-from', currentSliderContainer); //parent().find('.dp-slider-range-from');
    var inputToNumber = $('.dp-slider-range-to', currentSliderContainer); //$(currentSlider).parent().find('.dp-slider-range-to');
    // console.log(currentSliderContainer, inputFromNumber);
    //console.log($(inputFromNumber).val() +"-" + $(inputToNumber).val() + " mit " + $(inputFromNumber).attr('min')  +"-" + $(inputToNumber).attr('max'));
    noUiSlider.create(currentSlider, {
        start: [$(inputFromNumber).val(), $(inputToNumber).val()],
        connect: true,
        step: parseFloat($(inputFromNumber).attr('step')),
        range: {
            'min': parseFloat($(inputFromNumber).attr('min')),
            'max': parseFloat($(inputToNumber).attr('max'))
        }
    });
    /*
    currentSlider.noUiSlider.on('set', function (values, handle, unencoded, tap, positions, noUiSlider) {
	var value = values[handle];
	var step = noUiSlider.options.step;
            var decimals = -Math.floor(Math.log10(step));
	console.log('SET: step=' + step + ', decimals=' + decimals + ', value=' +value, noUiSlider.get());

    });
*/
    currentSlider.noUiSlider.on('update', function(values, handle, unencoded, tap, positions, noUiSlider) {
        var value = values[handle];
        var step = noUiSlider.options.step;

        if (step == 1) {
            value = parseInt(value);
        } else if (step > 0 && step < 1) {
            var decimals = -Math.floor(Math.log10(step));
            if (decimals > 0) {
                value = parseFloat(value).toFixed(decimals); //.replace(',', '.');
            }
            // console.log('step=' + step + ', decimals=' + decimals + ', value=' +value, noUiSlider.get());
        }
        if (!handle) {
            $(inputFromNumber).val(value);
        } else {
            $(inputToNumber).val(value);
        }
    });

    $(inputFromNumber).on('change', function() {
        currentSlider.noUiSlider.set([this.value, null]);
    });

    $(inputToNumber).on('change', function() {
        currentSlider.noUiSlider.set([null, this.value]);
    });

});
