<?php

declare (strict_types = 1);

namespace Internetgalerie\IgDynval\Controller;

use Doctrine\Common\Annotations\DocParser;
use Internetgalerie\IgDynval\Event\GetPropertyValidatorConfigEvent;
use Internetgalerie\IgDynval\Validation\Validator\ConjunctionValidator;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Internetgalerie\IgDynval\Validation\Validator\InjectableInterface;
use Internetgalerie\IgDynval\Validation\Validator\SettableInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Annotation\Validate;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Controller\Argument;
use TYPO3\CMS\Extbase\Mvc\Controller\Arguments;
use TYPO3\CMS\Extbase\Validation\ValidatorClassNameResolver;
use TYPO3\CMS\Extbase\Validation\Validator\ValidatorInterface;

/**
 * This file is part of the "dynval" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2022 Simon Häsler  <sh@internetgalerie.ch>, Internetgalerie AG
 */

/**
 * DynamicValidationActionController
 */
trait DynamicValidationActionController
{
    protected function initializeActionMethodValidators(): void
    {
        parent::initializeActionMethodValidators();

        //$this->settings['hasOriginalRequest'] = $this->request !== null;

        $argumentNames = array_values($this->arguments->getArgumentNames());

        // This can be from typoscript or where ever...
        $classSchemaMethod = $this->reflectionService->getClassSchema(static::class)
             ->getMethod($this->actionMethodName);

        foreach ($argumentNames as $argumentName) {
            $getValidatorConfigEvent = $this->eventDispatcher->dispatch(new GetPropertyValidatorConfigEvent($this->settings, $argumentName, $this->request->getControllerActionName(), $this->request->getPluginName()));
            $validators = $getValidatorConfigEvent->getValidatorConfigForParam();
            if (isset($this->settings['validators']) && $this->settings['validators'] && $this->settings['validators'][$argumentName]) {
                $validators = array_merge_recursive($this->settings['validators'][$argumentName], $validators);
            }
            $classSchemaMethodParameter = $classSchemaMethod->getParameter($argumentName);
            if (!$classSchemaMethodParameter->ignoreValidation()) {
                $this->modifyValidatorsBasedOnSettings(
                    $this->arguments->getArgument($argumentName),
                    $validators,
                    $classSchemaMethodParameter
                );
            }
        }
    }

    protected function modifyValidatorsBasedOnSettings(
        Argument $argument,
        array $configuredValidators,
        $classSchemaMethodParameter
    ) {
        $parser = new DocParser();

        /** @var DynamicValidator $validator */
        foreach($classSchemaMethodParameter->getValidators() as $validator) {
            if($validator['className'] == DynamicValidator::class) {
                $validator = GeneralUtility::makeInstance($validator['className']);
                $validator->injectEventDispatcher($this->eventDispatcher);
                $validator->setParamName($argument->getName());
                $validator->setActionName($this->request->getControllerActionName());
                $validator->setPluginName($this->request->getPluginName());

                foreach ($configuredValidators as $fieldName => $configuredValidator) {
                    if (!is_array($configuredValidator)) {
                        $validatorInstance = $this->getValidatorByConfiguration(
                            $configuredValidator,
                            $parser
                        );

                        if ($validatorInstance instanceof SettableInterface) {
                            $validatorInstance->setPropertyName($fieldName);
                        }
                    } else {
                        $validatorInstance = GeneralUtility::makeInstance(
                            ConjunctionValidator::class
                        );
                        foreach ($configuredValidator as $individualConfiguredValidator) {
                            $individualValidatorInstance = $this->getValidatorByConfiguration(
                                $individualConfiguredValidator,
                                $parser
                            );

                            if ($individualValidatorInstance instanceof SettableInterface) {
                                $individualValidatorInstance->setPropertyName($fieldName);
                            }

                            $validatorInstance->addValidator($individualValidatorInstance);
                        }
                    }

                    $validator->addPropertyValidator($fieldName, $validatorInstance);
                }

                $argument->setValidator($validator);
            }
        }
    }

    protected function getValidatorByConfiguration(string $configuration, DocParser $parser): ValidatorInterface
    {
        if (strpos($configuration, '"') === false && strpos($configuration, '(') === false) {
            $configuration = '"' . $configuration . '"';
        }

        /** @var Validate $validateAnnotation */
        $validateAnnotation = current($parser->parse('@' . Validate::class . '(' . $configuration . ')'));
        $validatorObjectName = ValidatorClassNameResolver::resolve($validateAnnotation->validator);

        if (in_array(InjectableInterface::class, class_implements($validatorObjectName))) {
            /** @var ValidatorInterface|InjectableInterface $validator */
            $validator = GeneralUtility::makeInstance($validatorObjectName);
            $validator->setOptions($validateAnnotation->options);
        } else {
            /** @var ValidatorInterface $validator */
            $validator = GeneralUtility::makeInstance($validatorObjectName, $validateAnnotation->options);
        }

        return $validator;
    }

    protected function initializeActionMethodArguments(): void
    {
        if (!$this->arguments) {
            $this->arguments = GeneralUtility::makeInstance(Arguments::class);
        }
        parent::initializeActionMethodArguments();
    }
}
