<?php

declare (strict_types = 1);

namespace Internetgalerie\IgDynval\Event;

final class ValidateParamEvent
{
    private $object;
    private $result;
    private $paramName;
    private $actionName;
    private $pluginName;

    public function __construct($object, $result, $paramName, $actionName, $pluginName)
    {
        $this->object = $object;
        $this->result = $result;
        $this->paramName = $paramName;
        $this->actionName = $actionName;
        $this->pluginName = $pluginName;
    }

    /**
     * Get the value of Object
     *
     * @return mixed
     */
    public function getObject()
    {
        return $this->object;
    }

    /**
     * Set the value of Object
     *
     * @param mixed $object
     *
     * @return self
     */
    public function setObject($object)
    {
        $this->object = $object;

        return $this;
    }

    /**
     * Get the value of Result
     *
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set the value of Result
     *
     * @param mixed $result
     *
     * @return self
     */
    public function setResult($result)
    {
        $this->result = $result;

        return $this;
    }


    /**
     * Get the value of Param Name
     *
     * @return string
     */
    public function getParamName()
    {
        return $this->paramName;
    }

    /**
     * Set the value of Param Name
     *
     * @param string $paramName
     *
     * @return self
     */
    public function setParamName($paramName)
    {
        $this->paramName = $paramName;

        return $this;
    }

    public function getActionName()
    {
        return $this->actionName;
    }
    
    public function setActionName($actionName)
    {
        $this->actionName = $actionName;
    }

    public function getPluginName()
    {
        return $this->pluginName;
    }

    public function setPluginName($pluginName)
    {
        $this->pluginName = $pluginName;
    }

}
