<?php

declare (strict_types = 1);

namespace Internetgalerie\IgDynval\Event;

final class GetPropertyValidatorConfigEvent
{
    private array $settings;
    private array $validatorConfig;
    private string $paramName;
    private string $actionName;
    private string $pluginName;

    public function __construct(array $settings = [], string $paramName, string $actionName, string $pluginName)
    {
        $this->settings = $settings;
        $this->validatorConfig = [];
        $this->paramName = $paramName;
        $this->actionName = $actionName;
        $this->pluginName = $pluginName;
    }

    public function getSettings()
    {
        return $this->settings;
    }

    public function getValidatorConfig()
    {
        return $this->validatorConfig;
    }

    public function getParamName()
    {
        return $this->paramName;
    }

    public function getValidatorConfigForParam()
    {
        if(isset($this->validatorConfig[$this->paramName]) && $this->validatorConfig[$this->paramName]) {
            return $this->validatorConfig[$this->paramName];
        }
        return [];
    }

    /**
     * Generates the Property Validator Annotation for a Validator
     * @param string $field
     * @param string $validator
     * @param array  $options
     */
    public function addValidator(string $field, string $validator, array $options = [])
    {
        if(!isset($this->validatorConfig[$this->paramName])) {
            $this->validatorConfig[$this->paramName] = [];
        }
        if(!isset($this->validatorConfig[$this->paramName][$field])) {
            $this->validatorConfig[$this->paramName][$field] = [];
        }
        if(empty($options)) {
            $this->validatorConfig[$this->paramName][$field][] = '"' . $validator . '"';
        } else {
            $validatorWithOptions = '"' . $validator . '", options={';
            $i = 0;
            foreach($options as $optionName => $value) {
                if($i > 0) {
                    $validatorWithOptions .= ',';
                }
                $validatorWithOptions .= '"' . $optionName . '":' . (is_string($value) ? '"' . $value . '"' : $value);
                $i++;
            }
            $validatorWithOptions .= '}';
            $this->validatorConfig[$this->paramName][$field][] = $validatorWithOptions;
        }
    }

    public function getActionName()
    {
        return $this->actionName;
    }

    public function setActionName($actionName)
    {
        $this->actionName = $actionName;
    }

    public function getPluginName()
    {
        return $this->pluginName;
    }

    public function setPluginName($pluginName)
    {
        $this->pluginName = $pluginName;
    }
}
