<?php

namespace Internetgalerie\IgDynval\Validation\Validator;

/*
 * This file is developed by evoWeb.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Internetgalerie\IgDynval\Event\ValidateParamEvent;
use Psr\EventDispatcher\EventDispatcherInterface;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractGenericObjectValidator;
use TYPO3\CMS\Extbase\Validation\Validator\ObjectValidatorInterface;

class DynamicValidator extends AbstractGenericObjectValidator
{
    /**
     * Model that gets validated currently
     *
     * @var AbstractEntity
     */
    protected $model;

    protected EventDispatcherInterface $eventDispatcher;

    protected string $paramName = '';

    protected string $actionName = '';

    protected string $pluginName = '';

    public function injectEventDispatcher(EventDispatcherInterface $eventDispatcher): void
    {
        $this->eventDispatcher = $eventDispatcher;
    }

    public function setParamName($paramName)
    {
        $this->paramName = $paramName;
    }

    public function setActionName($actionName)
    {
        $this->actionName = $actionName;
    }

    public function setPluginName($pluginName)
    {
        $this->pluginName = $pluginName;
    }

    /**
     * Checks if the given value is valid according to the property validators.
     *
     * @param mixed $object The value that should be validated
     */
    protected function isValid(mixed $object): void
    {
        $this->model = $object;

        $this->eventDispatcher->dispatch(new ValidateParamEvent($object, $this->result, $this->paramName, $this->actionName, $this->pluginName));

        foreach ($this->propertyValidators as $propertyName => $validators) {
            $propertyValue = $this->getPropertyValue($object, $propertyName);
            $this->checkProperty($propertyValue, $validators, $propertyName);
        }
    }

    /**
     * Checks if the specified property of the given object is valid, and adds
     * found errors to the $messages object.
     */
    protected function checkProperty(mixed $value, \Traversable $validators, string $propertyName): void
    {
        /** @var \TYPO3\CMS\Extbase\Error\Result $result */
        $result = null;
        foreach ($validators as $validator) {
            if ($validator instanceof SettableInterface) {
                $validator->setModel($this->model);
            }

            if ($validator instanceof ObjectValidatorInterface) {
                $validator->setValidatedInstancesContainer($this->validatedInstancesContainer);
            }
            $currentResult = $validator->validate($value);
            if ($currentResult->hasMessages()) {
                if ($result == null) {
                    $result = $currentResult;
                } else {
                    $result->merge($currentResult);
                }
            }
        }
        if ($result != null) {
            $this->result->forProperty($propertyName)->merge($result);
        }
    }

    /**
     * Checks if validator can validate the object
     *
     * @param AbstractEntity $object
     *
     * @return bool
     */
    public function canValidate($object): bool
    {
        return $object instanceof AbstractEntity;
    }
}
