<?php

namespace Internetgalerie\IgExcel\Utility;
use TYPO3\CMS\Core\Database\Connection;

use Internetgalerie\IgsCrm\Domain\Model\Anrede;
use Internetgalerie\IgsCrm\Domain\Model\Language;
use Internetgalerie\IgsCrm\Domain\Repository\AnredeRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ImportUtility
{
    protected $debug = false;

    protected $fp = null;
    protected $importConfig = null;
    protected $config = null;
    protected $mainTable = null;
    protected array $relations = [];
    protected array $filters = [];
    protected int $insertCount = 0;
    protected int $updateCount = 0;

    public function open(string $filename, $importConfig = null): void
    {
        $this->importConfig = $importConfig;
        $this->initDefaultFilters();
        if (($this->fp = fopen($filename, 'r')) === false) {
            die('<h1>File is missing</h1>');
        }
        if ($importConfig === null) {
            return;
        }
        for ($i = 0; $i < $this->importConfig->getIgnoreLinesAtBegining() + ($this->importConfig->getHasHeaderLine() ? 1 : 0); $i++) {
            fgetcsv($this->fp);
        }
        /*
        $this->config=$this->importConfig->getConfig();
        $this->mainTable=$this->config['mainTable'];
        $this->relations=$this->config['relations'];
        */
        $this->insert = 0;
        $this->update = 0;
    }
    
    public function close(): bool
    {
        return fclose($this->fp);
    }
  
    public function getLine()
    {
        if (($data = fgetcsv($this->fp)) === false) {
            return false;
        }
        $row = [];
        //$table=$this->importConfig->getTablename();
        foreach ($this->importConfig->getCols() as $nr => $col) {
            if ($col['attribute']) {
                $table = $col['table'] ?: $this->importConfig->getTablename();
                if (!isset($row[$table])) {
                    $row[$table] = [];
                }
                $val = $data[$nr];
                if (isset($col['default']) && $col['default'] !== '' && ($val === null || $val === '')) {
                    $val = $col['default'];
                }
                $filter = $col['filter'];
                if ($filter && $this->hasFilter($filter)) {
                    $val = $this->callFilter($filter, $val);
                    //$val = $this->{$func}($val);
                    /*
                      if($func=='getDate') {
                      die($table .'.'. $col['attribute'] .'='.$val);
                      }*/
                }

                $row[$table][$col['attribute']] = $val;
            }
        }
        return $row;
    }

    public function insertMainData(array $row): int
    {
        $this->insertCount++;
        if ($this->debug) {
            echo 'INSERT: ' . $this->mainTable['table'] . '<br />';
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            $this->mainTable['table']
        );
        // @todo fix/static
        $values = array_merge($this->mainTable['insertDefaultValues'], $row[$this->mainTable['table']]);
        $affectedRows = $queryBuilder->insert($this->mainTable['table'])->values($values)->executeStatement();
        $conn = $queryBuilder->getConnection();//GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->mainTable['table']);
        $lastInsertId = $conn->lastInsertId();
        if ($this->debug) {
            echo 'lastInsertId=' . $lastInsertId . '<br />';
        }
        if ($this->debug) {
            var_dump($row[$this->mainTable['table']]);
        }
        return $lastInsertId;//$db->->lastInsertId();
    }
    
    public function insertData(array $row): void
    {
        $uid = $this->insertMainData($row);
        foreach ($this->relations as $relation) {
            if ($this->debug) {
                echo 'INSERT: ' . $relation['table'] . '<br />';
            }
            if ($row[$relation['table']]['active']) {
                $row[$relation['table']][$relation['field']] = $uid;
                $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                    $relation['table']
                );
                $values = array_merge($relation['insertDefaultValues'], $row[$relation['table']]);
                $affectedRows = $queryBuilder->insert($relation['table'])->values($values)->executeStatement();
                if ($this->debug) {
                    var_dump($row[$relation['table']]);
                }
            }
        }
    }
    
    public function updateData(array $row, int $uid): void
    {
        $this->updateCount++;
        if ($this->debug) {
            echo 'UPDATE: ' . $this->mainTable['table'] . '<br />';
        }
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            $this->mainTable['table']
        );
        $values = array_merge($this->mainTable['updateDefaultValues'], $row[$this->mainTable['table']]);
        $queryBuilder->update($this->mainTable['table'])->where(
            $queryBuilder->expr()
->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT))
        );
        foreach ($values as $name => $value) {
            $queryBuilder->set($name, $value);
        }
        $queryBuilder->executeStatement();
        $lastInsertId = $uid;
        if ($this->debug) {
            var_dump($row[$this->mainTable['table']]);
        }
        foreach ($this->relations as $relation) {
            if ($this->debug) {
                echo 'UPDATE: ' . $relation['table'] . '<br />';
            }
            if ($row[$relation['table']]['active']) {
                $row[$relation['table']][$relation['field']] = $uid;
                //$row[$relation['table']][$relation['field']]=$uid;
                // @todo static
                $values = array_merge($relation['updateDefaultValues'], $row[$relation['table']]);
                // @todo testen ob existiert sonst insert
                $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                    $relation['table']
                );
    
                $queryBuilder->update($relation['table'])->where(
                    $queryBuilder->expr()
->eq('person', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT))
                );
                foreach ($values as $name => $value) {
                    $queryBuilder->set($name, $value);
                }
                $queryBuilder->executeStatement();
                if ($this->debug) {
                    var_dump($row[$relation['table']]);
                }
            }
        }
    }

    


    public function getInsertCount(): int
    {
        return $this->insertCount;
    }
    public function getUpdateCount(): int
    {
        return $this->updateCount;
    }
    public function addFilter(string $name, callable $filter): void
    {
        $this->filters[$name] = $filter;
    }
    public function removeFilter(string $name): void
    {
        if (isset($this->filters[$name])) {
            unset($this->filters[$name]);
        }
    }
    public function hasFilter(string $name): bool
    {
        return isset($this->filters[$name]);
    }
    public function getFilter(string $name): ?callable
    {
        return $this->filters[$name] ?? null;
    }
    public function callFilter(string $name, string $value)
    {
        return call_user_func($this->filters[$name], $value);
    }
    public function getFilters(): array
    {
        return $this->filters;
    }



    public function initDefaultFilters(): void
    {
        $this->addFilter('getBoolean', $this->getBoolean(...)); // non static
        $this->addFilter('getInt', $this->getInt(...)); // non static
        $this->addFilter('getDate', $this->getDate(...)); // non static
        $this->addFilter('getKanton', $this->getKanton(...)); // non static
        $this->addFilter('getAnrede', $this->getAnrede(...)); // non static
        $this->addFilter('getLanguage', $this->getLanguage(...)); // non static
        $this->addFilter('getDebitorUidByOwnNumber', $this->getDebitorUidByOwnNumber(...)); // non static
        //$this->addFilter('anrede', [__CLASS__, 'getAnrede']); // static
    }

    public function getAnrede(string $value): ?Anrede
    {
        if ($value == 'Herr' || $value == 'm') {
            $uid = 1;
        } elseif ($value == 'Frau' || $value == 'w' || $value == 'f') {
            $uid = 2;
        } elseif ($value == 'Firma' || $value == 'c') {
            $uid = 3;
        } else {
            return null;
        }
        $anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        return $anredeRepository->findOneByUid($uid);
    }

    public function getBoolean(string $value): bool
    {
        $letter = strtolower(substr(trim($value), 0, 1));
        if (intval($value) > 0 || $letter == 'j' || $letter == 'y' || $letter == 'x') {
            return true;
        }
        return false;
    }

    public function getInt(string $value): int
    {
        return intval(str_replace("'", '', $value));
    }
    public function getDate(string $value): string
    {
        if (strpos($value, '.')) {
            $parts = explode('.', $value);
            $y = intval(trim($parts[2]));
            $m = intval(trim($parts[1]));
            $d = intval(trim($parts[0]));
            if ($y < 100) {
                $y += 1900;
            }
            return $y . '-' . str_pad($m, 2, '0', STR_PAD_LEFT) . '-' . str_pad($d, 2, '0', STR_PAD_LEFT);
        }
        return $value;
    }

    public function getLanguage(string $value): ?Language
    {
        $languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $value = substr(trim($value), 0, 1);
        $uid = 1;
        if ($value == 'F' || $value == 'f') { //'Französisch'
            $uid = 3;
        } elseif ($value == 'E' || $value == 'e') { //'Englisch'
            $uid = 2;
        } elseif ($value == 'I' || $value == 'i') { //'Italienisch'
            $uid = 4;
        }
        return $languageRepository->findOneByUid($uid);
    }

    // IN unterklasse
    public function getKanton(string $value): ?int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_kanton'
        );
        $queryBuilder->select('uid')
      ->from('tx_igscrm_domain_model_kanton')
      ->where($queryBuilder->expr() ->eq('ka_abkuerzung', $queryBuilder->createNamedParameter($value)));
        $result = $queryBuilder->executeQuery();
        if ($row = $result->fetchAssociative()) {
            return $row['uid'];
        }
        return null;
    }
    public function getDebitorUidByOwnNumber(string $value): ?int
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_contact'
        );
        $queryBuilder
            ->select('uid')
            ->from('tx_igscrm_domain_model_contact')
            ->where($queryBuilder->expr() ->eq('me_addressid', $queryBuilder->createNamedParameter($value)));
        $result = $queryBuilder->executeQuery();

        if ($row = $result->fetchAssociative()) {
            return (int)$row['uid'];
        }
        return null;
    }
}
