   document.getElementById('formImportConfig').addEventListener('submit', function(event) {
       const spinner = document.getElementById('spinner');
       const importData = document.getElementById('import-data');

       importData.innerHTML = '';
       // Show the spinner during loading
       spinner.style.display = 'block';

       const checkboxTestChecked  = document.getElementById('fromImportTest').checked;
      // checkbox test not set -> do import on new page
       if (!checkboxTestChecked) {
	   // normal form submission (replace the whole page)
	   return;
       }
       
       event.preventDefault(); // Prevent the default form submission

       
       const actionUrl = this.getAttribute('action');
      // Prepare form data
      const formData = new FormData(this);
      // Perform asynchronous submission using Fetch API
      fetch(actionUrl, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.json())
      .then(data => {
          // Update the content of the import-data div
	  spinner.style.display  = 'none';
          importData.innerHTML = data.html;
	  importData.scrollIntoView({ behavior: 'smooth' });
        // Add click event to dynamically inserted anchor element
	  document.querySelectorAll('.scrollTo').forEach((scrollToAnchor, i) => {
              scrollToAnchor.addEventListener('click', function(event) {
		  event.preventDefault();
		  const targetId = this.getAttribute('data-target');
		  const targetElement = document.getElementById(targetId);
		  if (targetElement) {
		      targetElement.scrollIntoView({ behavior: 'smooth' });
		  }
	      });
          });
      })
	   .catch(error => {
	       console.error('Error submitting form:', error);
	       spinner.style.display  = 'none';
	   });
    });