<?php
defined('TYPO3') or die();


/**
 * Registers a Backend Module
 */
\TYPO3\CMS\Extbase\Utility\ExtensionUtility::registerModule(
    'IgExport',
    'Igshop2',	 // Make module a submodule of 'web' 'Igshop2'
    'backendOrder',	// Submodule key
    'after:backendProduct',						// Position info oder backendProduct
    [
        \InternetGalerie\IgExport\Controller\BackendOrderController::class => 'list, listCarts, show, submitOrder, exportOrders, exportOrder',

    ],
    [
        'access' => 'user,group',
        'workspaces'=> 'online',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop-order.svg',
        'labels' => 'LLL:EXT:ig_export/Resources/Private/Language/locallangNavOrder.xlf',
        'name' => 'IgShop2Frame_backendOrder',
        /*'navigationFrameModule' => 'IgShop2Frame', //file_navframe
        'navigationFrameModuleParameters' => [
            //'currentModule' => 'Igshop2_Igshop2Backendorder',
            'action' => 'pageTree',
        ],*/
        'navigationComponentId' => 'TYPO3/CMS/Backend/PageTree/PageTreeElement',

    ]
);
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTypoScriptSetup(
    '
    module.tx_igexport {
        view {
            templateRootPaths.1588324052 = EXT:ig_export/Resources/Private/Backend/Templates/
            partialRootPaths.1588324052 = EXT:ig_export/Resources/Private/Backend/Partials/
            layoutRootPaths.1588324052 = EXT:ig_export/Resources/Private/Backend/Layouts/
        }
    }'
);
