<?php

namespace Ig\IgFibu\Controller;

use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use TYPO3\CMS\Core\Messaging\FlashMessageService;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;

class AbstractFibuController extends ActionController
{
    protected $objectNames = ['object', 'newObject'];
    protected $dateObjects = [];
    protected $dateTimeObjects = [];
    protected $searchDefault = [];

    protected ?FlashMessageService $flashMessageService = null;

    public function injectFlashMessageService(FlashMessageService $flashMessageService): void
    {
        $this->flashMessageService = $flashMessageService;
    }

    /**
     * Add Function in Controller
     */
    public function initializeAction(): void
    {
        foreach ($this->objectNames as $objectName) {
            if (isset($this->arguments[$objectName])) {
                $object = $this->arguments[$objectName];
                if (!empty($this->dateObjects)) {
                    // Set date format of date fields
                    foreach ($this->dateObjects as $dateField) {
                        $object->getPropertyMappingConfiguration()
                               ->forProperty($dateField)
                               ->setTypeConverterOption(
                                   DateTimeConverter::class,
                                   DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                                   'Y-m-d'
                               );
                    }
                }
                if (!empty($this->dateTimeObjects)) {
                    // Set date format of date fields
                    foreach ($this->dateTimeObjects as $dateField) {
                        $object->getPropertyMappingConfiguration()
                               ->forProperty($dateField)
                               ->setTypeConverterOption(
                                   DateTimeConverter::class,
                                   DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                                   'Y-m-d H:i:s'
                               );
                    }
                }
            }
        }
    }

    public function hasAdvancedSearch($search, $exclude = []): bool
    {
        foreach ($search as $name => $value) {
            if (in_array($name, $exclude)) {
                continue;
            }
            if (is_array($value)) {
                $mode = $value['mode'] ?? '';
                if ($mode === 'equal') {
                    if (trim($value['equal'] ?? '') !== '') {
                        return true;
                    }
                } elseif ($mode === 'range') {
                    if (trim($value['from'] ?? '') !== '') {
                        return true;
                    }
                    if (trim($value['to'] ?? '') !== '') {
                        return true;
                    }
                }
                if ($value['date'] ?? false) {
                    return true;
                }
            } else {
                if ($value) {
                    return true;
                }
            }
        }
        return false;
    }
}
