<?php

namespace Ig\IgFibu\Controller;

use Ig\IgFibu\Domain\Model\PaymentImport;
use Ig\IgFibu\Domain\Repository\PaymentImportRepository;
use Internetgalerie\IgDoctrinePaginator\Pagination\DoctrinePaginator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Http\PropagateResponseException;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class PaymentImportController extends ActionController
{
    protected $searchDefault = [];

    /**
     * paymentImportRepository
     *
     * @var PaymentImportRepository
     */
    protected $paymentImportRepository = null;

    
    public function injectPaymentImportRepository(PaymentImportRepository $paymentImportRepository): void
    {
        $this->paymentImportRepository = $paymentImportRepository;
    }

    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $this->search = $this->getSearch();

        $paymentImportQueryBuilder = $this->paymentImportRepository->findBySearch($this->search);
        $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument('currentPage') : 1;

        $paginator = new DoctrinePaginator($paymentImportQueryBuilder, $currentPage, 50, PaymentImport::class);
        $pagination = $paginator->createSlidingWindowPagination(10);

        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);


        $verbands = [];
        if ($this->settings['mandant']['active']) {
            $this->verbandRepository = GeneralUtility::makeInstance($this->settings['mandant']['repository']);
            $verbands = $this->verbandRepository->findAllWithAcl(true);
        }
        $this->view->assign('verbands', $verbands);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action show
     */
    public function showAction(PaymentImport $paymentImport): ResponseInterface
    {
        $this->view->assign('paymentImport', $paymentImport);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action showXmlFile
     */
    public function showXmlFileAction(PaymentImport $paymentImport): ResponseInterface
    {
        $xmlFilePath = $paymentImport->getFilenameAbsolutePath();
        $filename = $paymentImport->getFilename();
        $xml = file_get_contents($xmlFilePath);
        $fileLength = strlen($xml);
        
        $response = $this->responseFactory->createResponse()
                                          ->withHeader('Content-Type', 'application/xml; charset=utf-8')
                                          ->withHeader('Expires', '0')
                                          ->withHeader('Cache-Control', 'private')
                                          ->withHeader('Cache-Control', 'must-revalidate, post-check=0, pre-check=0')
                                          ->withHeader(
                                              'Content-Disposition',
                                              'attachment; filename="' . $filename . '"'
                                          )
                                          ->withHeader('Content-Length', (string)$fileLength);
        //->withHeader('Content-Transfer-Encoding', 'binary')

        $response->getBody()
->write($xml);
        // The exception code is the HTTP status code to use (in this case 200).
        throw new PropagateResponseException($response, 200);
    }

    protected function getSearch()
    {
        $search = [];
        if ($this->request->hasArgument('@search')) {
            $search = $this->request->getArgument('@search');
        } elseif ($this->request->hasArgument('search')) {
            $search = $this->request->getArgument('search');
        } else {
            $search = $this->searchDefault;
        }

        return $search;
    }
}
