<?php

declare(strict_types=1);

namespace Ig\IgFibu\Database\Query;

use Ig\IgFibu\Service\DebitorService;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;

class BaseQueryBuilder extends QueryBuilder
{
    protected $entryTablename = null;
    protected $entryPrimaryKey = 'uid';
    protected $tenantIdAttribute = 'verband_id';

    /**
     * debitorService
     *
     * @var DebitorService
     */
    protected $debitorService = null;


    /**
     * Select
     *
     * @var Select
     */
    protected $sqlSelect = '*';


    
    public function injectDebitorService(DebitorService $debitorService): void
    {
        $this->debitorService = $debitorService;
    }

    public function resetSelect()
    {
        $this->sqlSelect = '*';
        return $this;
    }


    public function setEntryTablename($entryTablename)
    {
        $this->entryTablename = $entryTablename;
        return $this;
    }

    public function getEntryTablename()
    {
        return $this->entryTablename;
    }

    public function setEntryPrimaryKey($entryPrimaryKey)
    {
        $this->entryPrimaryKey = $entryPrimaryKey;
        return $this;
    }

    public function getEntryPrimaryKey()
    {
        return $this->entryPrimaryKey;
    }

    public function addUserRestriction()
    {
        $constraints = $this->debitorService->userRestriction($this, $this->tablename);
        
        //if ($this->settings['mandant']['active']) {
        $verbands = $this->debitorService->getMandants(true);
        $tenantsIds = [];
        foreach ($verbands as $verband) {
            $tenantsIds[] = $verband['uid'];
        }
        if (!empty($tenantsIds)) {
            $constraints[] = $this->expr()->in($this->tenantIdAttribute, $tenantsIds);
        }

        //       }
        
        if (!empty($constraints)) {
            $this->andWhere(...$constraints);
        }
        return $this;
    }
    /**
     * equal range constraints
     */
    protected function addEqualRangeConstrain(array $constraints, string $attribute, array $searchEntry = null)
    {
        if ($searchEntry === null) {
            return $constraints;
        }
        $mode = $searchEntry['mode'] ?? null;
        if ($mode === 'equal' || $mode === null) {
            if (isset($searchEntry['equal']) && $searchEntry['equal'] !== '') {
                $constraints[] = $this->expr()->eq($attribute, $this->createNamedParameter($searchEntry['equal']));
            }
        }
        if ($mode === 'starts' || $mode === null) {
            if (isset($searchEntry['starts']) && $searchEntry['starts'] !== '') {
                $constraints[] = $attribute  . ' LIKE ' . $this->createNamedParameter($search['entryNumber'] . '%');
                //$this->expr()->like($queryBuilder->expr()->literal($attribute), $this->createNamedParameter($searchEntry['starts'] . '%'));
            }
        }
        if ($mode === 'range' || $mode === null) {
            if (isset($searchEntry['from']) && $searchEntry['from'] !== '') {
                $constraints[] = $this->expr()->gte($attribute, $this->createNamedParameter($searchEntry['from']));
            }
            if (isset($searchEntry['to']) && $searchEntry['to'] !== '') {
                $constraints[] = $this->expr()->lte($attribute, $this->createNamedParameter($searchEntry['to']));
            }
        }
        return $constraints;
    }


    /**
     * starts range constraints, set $rawAttribute = true if $attribute is e.g. 'concat(a,b)'
     */
    protected function addStartsRangeConstrain(array $constraints, string $attribute, array|string $searchEntry = null, bool $rawAttribute = false)
    {
        if ($searchEntry === null) {
            return $constraints;
        }
        $mode = $searchEntry['mode'] ?? null;
        if ($mode === 'starts' || $mode === null) {
            if (is_array( $searchEntry)) {
                $value = trim($searchEntry['starts'] ?? '');
            } else {
                $value = trim((string)$searchEntry);
            }
            if ($value !== '') {
                if ($rawAttribute) {
                    $constraints[] = $attribute  . ' LIKE ' . $this->createNamedParameter($value . '%');
                } else {
                    $this->expr()->like($attribute, $this->createNamedParameter($value . '%'));
                }
            }
        }
        if ($mode === 'range' || $mode === null) {
            if (isset($searchEntry['from']) && $searchEntry['from'] !== '') {
                $fromValue = $searchEntry['from'];
                if ($rawAttribute) {
                    $constraints[] = $attribute  . ' >= ' . $this->createNamedParameter($fromValue);
                } else {
                    $constraints[] = $this->expr()->gte($attribute, $this->createNamedParameter($fromValue));
                }
            }
            if (isset($searchEntry['to']) && $searchEntry['to'] !== '') {
                $toValue = $searchEntry['to'];
                $toValue++;
                if ($rawAttribute) {
                    $constraints[] = $attribute  . ' < ' . $this->createNamedParameter($toValue);
                } else {
                    $constraints[] = $this->expr()->lt($attribute, $this->createNamedParameter($toValue));
                }
            }
        }
        return $constraints;
    }

    
    protected function addRawEqualRangeConstrain(array $constraints, string $attribute, array $searchEntry = null)
    {
        if ($searchEntry === null) {
            return $constraints;
        }
        $mode = $searchEntry['mode'] ?? null;
        if ($mode === 'equal' || $mode === null) {
            if (isset($searchEntry['equal']) && $searchEntry['equal'] !== '') {
                $constraints[] = $attribute . '=' . $this->createNamedParameter($searchEntry['equal']);
            }
        }
        if ($mode === 'range' || $mode === null) {
            if (isset($searchEntry['from']) && $searchEntry['from'] !== '') {
                $constraints[] = $attribute . '>=' . $this->createNamedParameter($searchEntry['from']);
            }
            if (isset($searchEntry['to']) && $searchEntry['to'] !== '') {
                $constraints[] = $attribute . '<=' . $this->createNamedParameter($searchEntry['to']);
            }
        }
        return $constraints;
    }
}
