<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;

class InvoiceDate extends AbstractEntity
{
    public const DELIVERY_METHOD_UNKNOWN = 0;
    public const DELIVERY_METHOD_DOWNLOAD = 1;
    public const DELIVERY_METHOD_EMAIL = 2;

    public const ACTION_CREATE = 0;
    public const ACTION_UPDATE = 1;
    public const ACTION_DELIVERY = 2;
    public const ACTION_UNDO = 3;
    public const ACTION_SET = 4;

    /**
     * createDate
     *
     * @var DateTime
     */
    protected $createDate = null;

    /**
     * invoiceDate
     *
     * @var DateTime
     */
    protected $invoiceDate = null;

    /**
     * invoice
     *
     * @var Invoice
     */
    protected $invoice = null;

    /**
     * status
     *
     * @var Invoicestatus
     */
    protected $status = null;

    /**
     * deliveryMethod
     */
    protected ?int $deliveryMethod = null;

    /**
     * action
     */
    protected int $action = 0;

    /**
     * frontendUser
     *
     * @var FrontendUser
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    protected $frontendUser;


    /**
     * logMail
     */
    protected ?int $logMail = null;
    
    public static function getBasePdfPath(): string
    {
        return Environment::getProjectPath() . '/data/invoices';
    }

    public static function getPdfPathByUid(int $uid): string
    {
        return self::getBasePdfPath() . '/invoice_' . $uid . '.pdf';
    }

    public function getPdfPath(): string
    {
        return self::getPdfPathByUid($this->uid);
    }

    public function getPdfExists(): bool
    {
        $pdfPath = $this->getPdfPath();
        return is_file($pdfPath);
    }

    public function getPdfContents(): ?string
    {
        $pdfPath = $this->getPdfPath();
        if (is_file($pdfPath)) {
            return file_get_contents($pdfPath);
        }
        return null;
    }
    public function getPdfSize(): ?int
    {
        $pdfPath = $this->getPdfPath();
        if (is_file($pdfPath)) {
            return filesize($pdfPath);
        }
        return null;
    }

    /**
     * Returns the createDate
     *
     * @return DateTime
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }

    /**
     * Sets the createDate
     */
    public function setCreateDate(DateTime $createDate = null): void
    {
        $this->createDate = $createDate;
    }

    /**
     * Returns the invoiceDate
     *
     * @return DateTime
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }

    /**
     * Sets the invoiceDate
     */
    public function setInvoiceDate(?DateTime $invoiceDate): void
    {
        $this->invoiceDate = $invoiceDate;
    }

    /**
     * Returns the invoice
     *
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * Sets the invoice
     */
    public function setInvoice(Invoice $invoice): void
    {
        $this->invoice = $invoice;
    }

    /**
     * Returns the status
     *
     * @return Invoicestatus
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Sets the status
     */
    public function setStatus(Invoicestatus $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns the deliveryMethod
     */
    public function getDeliveryMethod(): ?int
    {
        return $this->deliveryMethod;
    }

    /**
     * Sets the deliveryMethod
     */
    public function setDeliveryMethod(?int $deliveryMethod): void
    {
        $this->deliveryMethod = $deliveryMethod;
    }

    /**
     * Returns the action
     */
    public function getAction(): int
    {
        return $this->action;
    }

    /**
     * Sets the action
     */
    public function setAction(int $action): void
    {
        $this->action = $action;
    }
    /**
     * Returns the frontendUser
     *
     * @return FrontendUser
     */
    public function getFrontendUser()
    {
        if ($this->frontendUser instanceof LazyLoadingProxy) {
            $this->frontendUser = $this->frontendUser->_loadRealInstance();
        }
        return $this->frontendUser;
    }

    /**
     * Sets the frontendUser
     */
    public function setFrontendUser(FrontendUser $frontendUser): void
    {
        $this->frontendUser = $frontendUser;
    }

    /**
     * Returns the logMail
     */
    public function getLogMail(): ?int
    {
        return $this->logMail;
    }

    /**
     * Sets the logMail
     */
    public function setLogMail(?int $logMail): void
    {
        $this->logMail = $logMail;
    }
}
