<?php

declare(strict_types=1);

namespace Ig\IgFibu\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * PaymentInvoice
 */
class InvoicePayment extends AbstractEntity
{
    /**
     * amountApplied
     *
     * @var float
     */
    protected $amountApplied = 0.0;

    /**
     * bookingDate
     *
     * @var DateTime
     */
    protected $bookingDate = null;

    /**
     * invoice
     *
     * @var Invoice
     */
    protected $invoice = null;

    /**
     * payment
     *
     * @var Payment
     */
    protected $payment = null;

    /**
     * credit
     *
     * @var Credit
     */
    protected $credit = null;

    /**
     * post payment
     *
     * @var bool
     */
    protected $postPayment = false;

    /**
     * tenantId
     *
     * @var int
     */
    protected $tenantId = 0;

    /**
     * debitorId
     *
     * @var int
     */
    protected $debitorId = 0;

    /**
     * Returns the amountApplied
     *
     * @return float
     */
    public function getAmountApplied()
    {
        return $this->amountApplied;
    }
    /**
     * Returns the amountApplied * -1 : for output in invoices
     *
     * @return float
     */
    public function getAmountAdded()
    {
        return $this->amountApplied * -1;
    }

    /**
     * Sets the amountApplied
     */
    public function setAmountApplied(float $amountApplied): void
    {
        $this->amountApplied = $amountApplied;
    }

    /**
     * Returns the bookingDate
     *
     * @return DateTime
     */
    public function getBookingDate()
    {
        return $this->bookingDate;
    }

    /**
     * Sets the bookingDate
     */
    public function setBookingDate(DateTime $bookingDate): void
    {
        $this->bookingDate = $bookingDate;
    }

    /**
     * Returns the invoice
     *
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * Sets the invoice
     */
    public function setInvoice(Invoice $invoice): void
    {
        $this->invoice = $invoice;
    }

    /**
     * Returns the payment
     *
     * @return Payment
     */
    public function getPayment()
    {
        return $this->payment;
    }

    /**
     * Sets the payment
     */
    public function setPayment(Payment $payment): void
    {
        $this->payment = $payment;
    }

    /**
     * Returns the credit
     *
     * @return Credit
     */
    public function getCredit()
    {
        return $this->credit;
    }

    /**
     * Sets the credit
     */
    public function setCredit(Credit $credit): void
    {
        $this->credit = $credit;
    }

    public function getPostPayment(): bool
    {
        return $this->postPayment;
    }

    public function setPostPayment(bool $postPayment): void
    {
        $this->postPayment = $postPayment;
    }

    public function isPostPayment(): bool
    {
        return $this->postPayment;
    }

    /**
     * Returns the tenantId
     *
     * @return int
     */
    public function getTenantId()
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the debitorId
     *
     * @return int
     */
    public function getDebitorId()
    {
        return $this->debitorId;
    }

    /**
     * Sets the debitorId
     */
    public function setDebitorId(int $debitorId): void
    {
        $this->debitorId = $debitorId;
    }

    public function getCanUndo(): bool
    {
        $credit = $this->getCredit();
        $payment = $this->getPayment();
        if ($credit && $payment && !$credit->getIsDone()) {
            return true;
        }
        $invoice = $this->getInvoice();
        if ($invoice && $invoice->getCanEdit()) {
            if ($credit && $credit->getIsDone()) {
                return true;
            }
            if (!$credit && $payment) {
                return true;
            }
            if ($credit && !$payment && !$credit->getIsDone()) {
                return true;
            }
        }
        return false;
    }
    public function getUndoDeleteCredit(): bool
    {
        $credit = $this->getCredit();
        return $credit && !$credit->getIsDone() && !$this->getInvoice() && $this->getPayment();
    }
}
