<?php

namespace Ig\IgFibu\Utility;

use DateTime;
use Exception;
use Ig\IgFibu\Domain\Model\Address;
use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceDate;
use Ig\IgFibu\Domain\Model\InvoiceInterface;
use Ig\IgFibu\Event\SubtotalEvent;
use Ig\IgFibu\ReferenceFormatter\DefaultReferenceFormatter;
use Ig\IgFibu\ReferenceFormatter\ReferenceFormatterResult;
use Ig\IgFibu\TaxBehavior;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateLetter;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplatePageLayout;
use Internetgalerie\IgCrmTemplate\Utility\TemplateUtility;
use Internetgalerie\IgRender\Utility\PdfUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactVerband;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use Internetgalerie\IgsCrm\Domain\Model\Person;
use Locale;
use Psr\EventDispatcher\EventDispatcherInterface;
use Sprain\SwissQrBill as QrBill;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\TypoScript\TypoScriptService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\TemplateView;
use TYPO3\CMS\Fluid\View\FluidViewAdapter;

class InvoiceUtility implements SingletonInterface
{
    public const OUTPUT_PDF_DIE = 0;
    public const OUTPUT_HTML_DIE = 1;
    public const OUTPUT_PDF_RETURN = 2;
    public const OUTPUT_HTML_RETURN = 3;

    public static $referenceFormatterClasses = [];
    public static $referenceFormatters = null;

    //protected int $countQrInvoice = 0;

    /**
     * pdfOutputMode
     * @var bool
     */
    protected $pdfOutputMode = self::OUTPUT_PDF_DIE;//true;
    protected $debitorErrorCount = 0;
    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var TypoScriptService
     */
    protected $typoScriptService;

    
    public function __construct(
        TypoScriptService $typoScriptService,
        ConfigurationManagerInterface $configurationManager,
        protected EventDispatcherInterface $eventDispatcher
    ) {
        $this->configurationManager = $configurationManager;
        $this->typoScriptService = $typoScriptService;
        
        $all = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $this->settings = $this->typoScriptService->convertTypoScriptArrayToPlainArray(
            $all['plugin.']['tx_igfibu.']['settings.'] ?? []
        );
    }

    public function setDebitorErrorCount(int $debitorErrorCount): void
    {
        $this->debitorErrorCount = $debitorErrorCount;
    }
    public function getDebitorErrorCount(): int
    {
        return $this->debitorErrorCount;
    }
    public function applyDiscount(Invoice $invoice)
    {
    }
    public function calculateInvoice(Invoice $invoice): void
    {
        /*
        if (!$invoice->getCanEdit()) {
            return;
        }
        */
        $defaultTaxRate = (float) $this->settings['taxRate'];
        $items = $invoice->getInvoiceItems();
        $totalExkl = 0;
        $totalInkl = 0;
        $totalAmount = 0;
        $totalTax = 0;
        $taxBehavior = null;
        $itemTaxRate = null;
        //$canEdit = $invoice->getStatus()->getCanEdit();

        if (!empty($items)) {
            foreach ($items as $item) {
                $item->calculate();

                $taxRate = $item->getTaxRate();
                if ($item->getTaxRate() == 0) {
                    $item->setTaxRate($defaultTaxRate);
                }
                if ($itemTaxRate === null) {
                    $itemTaxRate = $item->getTaxRate();
                } else {
                    if ($itemTaxRate != $item->getTaxRate()) {
                        //die('discount not possible');
                    }
                }
                $itemTaxBehavior = $item->getTaxBehaviorEnum();
                if ($taxBehavior === null) {
                    $taxBehavior = $itemTaxBehavior;
                } else {
                    if ($itemTaxBehavior !== null) {
                        if ($itemTaxBehavior !== $taxBehavior) {
                            //die('mixed taxes in invoice; ' . $invoice->getUid());
                        }
                    }
                }
                if ($item->getTaxBehaviorIsExkl()) {
                    $itemAmount = $item->getAmount();
                    $itemTaxAmount = $itemAmount * $taxRate / 100;
                    //$itemTotalExkl = $item->getAmount();
                    //$itemTotalTax = $itemTotalExkl * $taxRate / 100;
                    //$itemTotalInkl = $itemTotalExkl + $itemTotalTax;
                } elseif ($item->getTaxBehaviorIsInkl()) {
                    $itemAmount = $item->getAmount();
                    $itemTaxAmount = $itemAmount / (100 + $taxRate) * $taxRate;
                    //$itemTotalInkl = $item->getAmount();
                    //$itemTotalExkl = $itemTotalInkl * 100 / $taxRate;
                    //$itemTotalTax = $itemTotalInkl - $itemTotalExkl;
                } else {
                    $itemAmount = $item->getAmount();
                }
                //$totalExkl += $itemTotalExkl;
                $totalTax += $itemTaxAmount;
                //$totalInkl += $itemTotalInkl;
                $totalAmount += $itemAmount;
                //echo('<h3>Item [' . $item->getUid() . '] ' . $item->getAmount() . '</h3>'); var_dump($itemTaxBehavior, $taxRate, $itemAmount, $itemTaxAmount);
            }
        }

        // Swiss VAT rate?
        // amount
        //amount_excluding_tax
        // subtotal_excluding_tax
        // call user hooks

        // round withou tax to cents
        /*
        $totalExkl = round($itemTaxAmount, 2);
        if ($taxBehavior == TaxBehavior::INCLUSIVE) {
            $invoice->setSubtotal(round($totalAmount, 2));
            $invoice->setSubtotalExkl($totalAmount - $totalTax);
        } else {
            $invoice->setSubtotal($totalAmount + $totalTax);
            $invoice->setSubtotalExkl($totalAmount);
        }
        */
        $invoice->setSubtotal(round($totalAmount, 2));
        if ($taxBehavior === TaxBehavior::EXCLUSIVE) {
            $invoice->setSubtotalExkl(round($totalAmount, 2));
        } else {
            $invoice->setSubtotalExkl(round($totalAmount - $totalTax, 2));
        }
        //echo ('inkl.= ' . $totalInkl . ', exkl=' . $totalExkl .'<br />');

        $subtotalEvent = $this->eventDispatcher->dispatch(
            new SubtotalEvent($invoice, $taxBehavior === TaxBehavior::EXCLUSIVE, $totalTax)
        );
        $invoice = $subtotalEvent->getInvoice();
        $totalTax = $subtotalEvent->getTotalTax();

        $totalAmount = $invoice->getSubtotal();


        // set discount
        $discountPercentage = $invoice->getDiscountPercentage();
        $totalDiscount = $totalAmount * $discountPercentage / 100;
        $discountAmount = $invoice->getDiscountAmount();
        $totalDiscount += $discountAmount;
        $invoice->setTotalDiscount($totalDiscount);

        $totalAmount -= $totalDiscount;

        // not working for differnet taxRates
        $totalTax -= $itemTaxRate / 100 * $totalDiscount;

        if ($taxBehavior === TaxBehavior::EXCLUSIVE) {
            $totalExkl = $totalAmount;
            $totalInkl = $totalAmount + $totalTax;
        } else {
            $totalInkl = $totalAmount;
            $totalExkl = $totalAmount - $totalTax;
        }
        //echo ('inkl.= ' . $totalInkl . ', exkl=' . $totalExkl .'<br />');        exit(0);


        $invoice->setTotalExkl($totalExkl);

        /*
        // dispatch Gutscheine
        if ($invoice->getReManuellNach1Preis() != 0) {
            $totalInkl += $invoice->getReManuellNach1Preis();
        }
        */

        // round to 0.05 cents
        $roundingPrecision = $invoice->getRoundingStep();
        $roundingFactor = $roundingPrecision <= 0.01 ? 100 : (1/$roundingPrecision);
        
        $totalInkl = round($totalInkl * $roundingFactor) / $roundingFactor;
        $invoice->setTotal($totalInkl);

        // set the tax as different -> or should we take the totalTax ?
        $totalTax = round($totalTax * $roundingFactor) / $roundingFactor;

        $invoice->setTotalTax($totalTax);
        //$invoice->setTotalTax($totalInkl - $totalExkl);
        //die('roundingFactor=' . $roundingFactor . 'totalInkl=' . $totalInkl . ', totalTax = ' . $totalTax);
    }

    public function calculateAmountPaid(Invoice $invoice): void
    {
        $invoicePaymentsValue = $invoice->getPaymentsTotal();
        $invoiceCurrentValue = $invoice->getAmountPaid();
        if ($invoicePaymentsValue != $invoiceCurrentValue) {
            $invoice->setAmountPaid($invoicePaymentsValue);
        }
    }
    public function calculatePrePaymentCreditAmount(Invoice $invoice): void
    {
        $invoicePaymentsValue = $invoice->getInvoicePaymentsCreditPreAmount();
        $invoiceCurrentValue = $invoice->getPrePaymentCreditAmount();
        if ($invoicePaymentsValue != $invoiceCurrentValue) {
            $invoice->setPrePaymentCreditAmount($invoicePaymentsValue);
        }
    }

    public function getInvoicePageUid(): int
    {
        return (int) $this->settings['invoicePid'];
    }

    public function getPaymentPageUid(): int
    {
        return (int) $this->settings['paymentPid'];
    }

    
    public function debitorAddressValidForInvoice(array $debitorAddress)
    {
        return $debitorAddress['name'] && $debitorAddress['zip'] && $debitorAddress['city'];
    }


    
    public function getPaymentPartByInvoice(
        Invoice $invoice,
        $receiver,
        string $languageCode,
        ?bool $usePayments = true
    ) {
        /*
        if ($languageCode === null) {
            $languageCode = $this->languageCode;
        }
        */
        $tenant = $invoice->getCreditor();
        if ($tenant === null) {
            die('no creditor is set in invoice. Add a default creditor or set one in the invoice');
        }
        $name = $tenant->getNameHr();
        $address = $tenant->getAddress();
        $zip = $tenant->getZip();
        $city = $tenant->getCity();
        $country = 'CH';
        $bankingCustomerIdentification = $tenant->getBankingCustomerIdentification();
        $qrIban = $tenant->getQrIban();
        
        $qrBill = QrBill\QrBill::create();
        // Add creditor information
        // Who will receive the payment and to which bank account?
        $qrBill->setCreditor(
                QrBill\DataGroup\Element\StructuredAddress::createWithStreet(
                    $name,
                    $address,
                    '', // street number (can be in address)
                    $zip,
                    $city,
                    $country
                )
                //QrBill\DataGroup\Element\CombinedAddress::create($name, $address, $zip . ' ' . $city, $country)
        );
        /*
        $qrBill->setCreditorInformation(
        QrBill\DataGroup\Element\CreditorInformation::create(
        'CH4431999123000889012' // Note that this is a special QR-IBAN which are currently not yet available in real life (as of June 2019)
        ));
         */
        // Add debtor information
        // Who has to pay the invoice? This part is optional.
        //
        // Notice how you can use two different styles of addresses: CombinedAddress or StructuredAddress.
        // They are interchangeable for creditor as well as debtor.
        if (method_exists($receiver, 'getQrDebitorAdresse')) {
            $receiverAddress = $receiver->getQrDebitorAdresse();
        } else {
            $receiverAddress = [
                'name' => $receiver->getName(),
                'address' => $receiver->getAddress(),
                'zip' => $receiver->getZip(),
                'city' => $receiver->getCity(),
                'country' => $receiver->getCountryIsoCode() ?: 'CH',
            ];
        }

        if (!$this->debitorAddressValidForInvoice($receiverAddress)) {
            $this->debitorErrorCount++;
            //   return $this->debitorErrorMessage($receiver, $receiverAddress);
        } else {
            $qrBill->setUltimateDebtor(
                QrBill\DataGroup\Element\StructuredAddress::createWithStreet(
                    $receiverAddress['name'],
                    $receiverAddress['address'],
                    '', // street number (can be in address)
                    $receiverAddress['zip'],
                    $receiverAddress['city'],
                    $receiverAddress['country']
                )
            );
        }

        // Add payment amount information
        // What amount is to be paid?
        if ($usePayments === true || ($usePayments === null && $invoice->getStatus()->getUsePayments())) {
            $amount = $invoice->getAmountOpen();
        } else {
            $amount = $invoice->getBetragEz();
        }
        if ($amount < (float)0 || ($amount === (float) 0 && $invoice->getTotal() > (float)0)) {
            // nichsts darstellen, text mit ueberweisung einblenden?
            return '';
        }
        if ($amount === (float) 0) {
            $amount = null;
        }
        $qrBill->setPaymentAmountInformation(
            QrBill\DataGroup\Element\PaymentAmountInformation::create('CHF', $amount)
        );
        
        // Add payment reference
        // This is what you will need to identify incoming payments.
        $referenceFormatterClass = $tenant->getReferenceFormatterClass() ?? DefaultReferenceFormatter::class;
        //$referenceFormatterClass = DefaultReferenceFormatter::class;
        $referenceFormatter = GeneralUtility::makeInstance($referenceFormatterClass);
        //$referenceResult = $this->resolveReference($referenceNumber, null); var_dump($referenceResult); die('n=' . $referenceNumber);
        /*
        */
        // QR-IBAN is available -> use TYPE_QR
        // only use QR-IBAN for switzerland and Liechtenstein (QR-IBAN not working in other countries)
        if (
            ($qrIban && ($receiverAddress['country'] == 'CH' || $receiverAddress['country'] == 'LI' || $receiverAddress['country'] == ''))
            || !$tenant->getIban()
        ) {
            $qrBill->setCreditorInformation(
                QrBill\DataGroup\Element\CreditorInformation::create(
                    $qrIban // Note that this is a special QR-IBAN
                )
            );

            $fakturaNummer = $referenceFormatter->getReference($invoice->getDebitor(), $invoice->getUid());

            // make it 27 digits long with check digit and old bankingCustomerIdentification if set
            $referenceNumber = QrBill\Reference\QrPaymentReferenceGenerator::generate(
                $bankingCustomerIdentification, // you receive this number from your bank, ist beim TYPE_QR nicht noetig und kann selbst verwendet werden
                $fakturaNummer
            );

            //die($invoice->getEntryId() .','. $invoice->getUid().'='. $referenceNumber . '('.strlen($referenceNumber).')');
            $qrBill->setPaymentReference(
                QrBill\DataGroup\Element\PaymentReference::create(
                    QrBill\DataGroup\Element\PaymentReference::TYPE_QR,
                    $referenceNumber
                )
            );
        } else {
            // no QR-IBAN -> use SCOR
            $qrBill->setCreditorInformation(
                QrBill\DataGroup\Element\CreditorInformation::create(
                    $tenant->getIban() // normal IBAN for SCOR Reference Type
                )
            );
            $fakturaNummer = $referenceFormatter->getRFReference($invoice->getDebitor(), $invoice->getUid());
            //$fakturaNummer = str_pad($fakturaNummer, 20, '0', STR_PAD_LEFT);
            $referenceNumber = QrBill\Reference\RfCreditorReferenceGenerator::generate($fakturaNummer);
            //var_dump($referenceNumber, $debitorNumber, $invoiceNumber);die('=' . $fakturaNummer . '=' . strlen($fakturaNummer));
            
            $qrBill->setPaymentReference(
                QrBill\DataGroup\Element\PaymentReference::create(
                    //QrBill\DataGroup\Element\PaymentReference::TYPE_QR,
                    //$referenceNumber
                    QrBill\DataGroup\Element\PaymentReference::TYPE_SCOR,
                    $referenceNumber
                )
            );
        }

        /*
        $qrBill->setPaymentReference(
        QrBill\DataGroup\Element\PaymentReference::create(
        QrBill\DataGroup\Element\PaymentReference::TYPE_QR,
        $referenceNumber
        ));
         */
        /*
        try {
        $qrBill->getQrCode()->writeFile('/var/www/igs-ch/admin.dev/typo3temp/qr.png');
        $qrBill->getQrCode()->writeFile('/var/www/igs-ch/admin.dev/typo3temp/qr.svg');
        } catch (Exception $e) {
        foreach($qrBill->getViolations() as $violation) {
        print $violation->getMessage()."\n";
        }
        exit;
        }
         */
        $output = new QrBill\PaymentPart\Output\HtmlOutput\HtmlOutput($qrBill, $languageCode);
        //var_dump($qrBill->getViolations());

        $output->setQrCodeImageFormat('png');
        //$output->setQrCodeImageFormat('svg');
        $paymentPart = '';
        try {
            $paymentPart = $output->setPrintable(false)
->getPaymentPart();
        } catch (Exception) {
            echo '<h1>QrBill Error in QR-Code generation</h1>';
            echo '<strong>Invoice Number: ' . $invoice->getUid() . '</strong><br />';
            echo '<strong>Debitor: ' . $receiverAddress['name'] . ' (' . $invoice->getDebitor()->getNumber() . ')</strong> (Lenght: ' . strlen(
                (string) $receiverAddress['name']
            ) . ')<br />';
            foreach ($qrBill->getViolations() as $violation) {
                print $violation->getPropertyPath() . ': ' . $violation->getMessage() . "\n";
            }
            exit;
        }
        return $paymentPart;
    }

    public function resolveReference(string $reference, ?int $tenantId): ReferenceFormatterResult
    {
        foreach ($this->getReferenceFormatters() as $referenceFormatter) {
            if ($referenceFormatter->canConvert($reference, $tenantId)) {
                return $referenceFormatter->convert($reference, $tenantId);
            }
        }
        return ReferenceFormatterResult::createErrorMessage(
            'unknown reference format "' . $reference . '" with tenantId=' . $tenantId
        );
    }
    public static function registerReferenceFormatter($class): void
    {
        static::$referenceFormatterClasses[] = $class;
    }
    public function getReferenceFormatters()
    {
        if (static::$referenceFormatters === null) {
            static::$referenceFormatters = [];
            foreach (static::$referenceFormatterClasses as $referenceFormatterClass) {
                static::$referenceFormatters[] = GeneralUtility::makeInstance($referenceFormatterClass);
            }
            // reverse sort priority, higher first
            usort(
                static::$referenceFormatters,
                fn ($a, $b) => strcmp((string) $b->getPriority(), (string) $a->getPriority())
            );
        }
        return static::$referenceFormatters;
    }


    public function getCss($verband = null, array $additionalCssFiles = []): string
    {
        $css = '';
        //defaultl invoice
        $cssFile = GeneralUtility::getFileAbsFileName('EXT:ig_fibu/Resources/Public/Css/invoice.css');
        $css .= file_get_contents($cssFile);
        // qr stuff
        $cssFile = GeneralUtility::getFileAbsFileName('EXT:ig_fibu/Resources/Public/Css/qr.css');
        $css .= "\n" . file_get_contents($cssFile);

        if ($_GET['debug'] ?? false) {
            $css .= "\n" . file_get_contents(
                GeneralUtility::getFileAbsFileName('EXT:ig_fibu/Resources/Public/Css/debug.css')
            );
        }

        if ($verband && $verband->getInvoiceCss()) {
            $cssFile = GeneralUtility::getFileAbsFileName($verband->getInvoiceCss());
            if (file_exists($cssFile)) {
                $css .= "\n" . file_get_contents($cssFile);
            }
        }
        /*
        $cssFile = GeneralUtility::getFileAbsFileName('EXT:ig_pedos/Resources/Public/Css/pdf-header.css');
        if (file_exists($cssFile)) {
            $css .= "\n" . file_get_contents($cssFile);
        }
        $cssFile = GeneralUtility::getFileAbsFileName('EXT:ig_pedos/Resources/Public/Css/invoice.css');
        if (file_exists($cssFile)) {
            $css .= "\n" . file_get_contents($cssFile);
        }
        */
        
        if (!empty($additionalCssFiles)) {
            foreach ($additionalCssFiles as $additionalCssFile) {
                if ($additionalCssFile) {
                    $cssFile = GeneralUtility::getFileAbsFileName($additionalCssFile);
                    if ($cssFile && file_exists($cssFile)) {
                        $css .= "\n" . file_get_contents($cssFile);
                    }
                }
            }
        }

        $defaultEzMarginTop = 0;
        $defaultBodyMarginTop = 4;
        $userCss = 'html .ez {margin-top: ' . intval($defaultEzMarginTop) . 'px;}';

        //$userCss .= 'html body {margin-top: ' . floor($defaultBodyMarginTop+$crmSettingsPrinterMarginTop/10) . 'px;}}' . "\m";

        $css .= "\n" . $userCss;
        //$css .= "\n" . $crmSettingsCustomCss;
        return $css;
    }

    public function getJavaScriptPrintDialog(): string
    {
        $javaScriptFile = 'EXT:ig_fibu/Resources/Public/JavaScript/printPreview.js';
        $javaScript = file_get_contents(GeneralUtility::getFileAbsFileName($javaScriptFile));
        return '<script>' . $javaScript . '</script>';
    }
    public function getCrmLanguageUidByContact($contact, array $allowedLanguageCodes = ['de', 'fr']): int
    {
        $crmLanguageUid = null;
        if (method_exists($contact, 'getLanguageWithFallback')) {
            $crmLanguage = $contact->getLanguageWithFallback($allowedLanguageCodes);
            if (is_object($crmLanguage)) {
                $crmLanguageUid = $crmLanguage->getUid();
            }
        }
        if ($crmLanguageUid === null) {
            $crmLanguageCode = $contact->getLanguageCode();
            $crmLanguageUid = $crmLanguageCode == 'fr' ? 2 : 1;
        }
        return $crmLanguageUid;
    }
    public function getCrmLanguageLocaleByContact($contact, array $allowedLanguageCodes = ['de', 'fr']): string
    {
        if (method_exists($contact, 'getFallbackLanguageLocale')) {
            return $contact->getFallbackLanguageLocale($allowedLanguageCodes);
        }
        return $contact->getLanguageLocale();
    }
    public function setSender($invoice): void
    {
        $sender = $invoice->getCreditor();
        $this->sender = $sender;
    }
    public function setReceiver($invoice, bool $dieOnError = true): void
    {
        //$invoice->getInvoiceAddress();
        //$invoice->getDeliveryAddress();
        $receiver = $invoice->getDebitor();
        // CRM Stuff
        if ($receiver instanceof Contact) {
            $address = null;
            // is a extra invoice address defined
            $verband = $invoice->getCreditor();
            $contactVerband = $receiver->getContactVerbandById($verband->getUid());
            if ($contactVerband instanceof ContactVerband) {
                $extaAddress = $contactVerband->getCombinedInvoiceAddress();
                if ($extaAddress !== null) {
                    $address = new Address();
                    $address->set($extaAddress);
                    //$address->setContactPerson($receiver->getAnredeSprache() . ' ' . $receiver->getName());
                    if ($extaAddress instanceof Organisation && $receiver instanceof Person) {
                        $address->setContactPerson($receiver);
                    }
                }
            }
            // is an organisation and has a contact Person (RespPerson)
            if ($receiver instanceof Organisation) {
                if ($address === null) {
                    $address = new Address();
                    $address->set($receiver);
                }
                $contactPerson = $receiver->getContactPerson();
                if ($contactPerson instanceof Person) {
                    $address->setContactPerson(
                        $contactPerson
                    );//->getAnredeSprache() . ' ' . $contactPerson->getName());
                }
            }
            // we have found something and we use it
            if ($address !== null) {
                $receiver = $address;
            }
        } else {
            // normal address e.g. Organisation
            if ($receiver) {
                $this->receiver = $receiver;
            } else {
                if ($dieOnError) {
                    //var_dump($receiver);
                    die('<h3 style="color: red;">Rechnung ' . $invoice->getUid() . ' fehlt Debitor mit EntryID = ' . $invoice->getEntryUId() . ' und MandantID= ' . $invoice->getCreditorId() . '</h3>');
                }
                $this->receiver = null;
            }
        }
        $this->receiver = $receiver;
    }
    public function getReceiver()
    {
        return $this->receiver;
    }
    public function setLanguage($invoice): void
    {
        $debitor = $invoice->getDebitor();
        $this->languageCode = is_object($debitor) ? $debitor->getLanguageCodeWithFallback() : 'de';
    }
    public function assignInvoice($view, InvoiceInterface $invoice, ?bool $usePayments = true): void
    {
        $this->setSender($invoice);
        $this->setReceiver($invoice);
        $this->setLanguage($invoice);

        $view->assign('sender', $this->sender);
        $view->assign('receiver', $this->receiver);
        //$view->assign('usePayments', $usePayments);

        $verband = $invoice->getCreditor();
        $view->assign('invoice', $invoice);
        // BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBUG (added 23.3.2023, removed 16.9.2024)
        //var_dump($usePayments);exit(0);
        //$usePayments = true;
        $content = $this->getPaymentPartByInvoice(
            $invoice,
            $this->receiver,
            $this->languageCode,
            $usePayments
        ); //sollte  $usePayments); sein
        //$content = $this->getQrInvoice($invoice, $usePayments);
        $view->assign('content', $content);
    }
    public function setPdfOutputMode($pdfOutputMode): void
    {
        $this->pdfOutputMode = $pdfOutputMode;
    }
    public function getPdfOutputMode()
    {
        return $this->pdfOutputMode;
    }

    public function noTemplateFoundError(
        string $templateName,
        InvoiceInterface $invoice,
        $contact,
        $crmLanguageUid = null
    ): void {
        echo '<h1>Error: No template found</h1>';
        $verband = $invoice->getVerband();
        if (is_object($verband)) {
            echo 'Mandant: ' . $verband->getName() . ' (' . $verband->getUid() . ')<br />';
        }
        echo 'Invoice UID: ' . $invoice->getType() . '<br />';
        echo 'Debitor Number: ' . $contact->getNumber() . '(' . $contact->getUid() . ')<br />';
        echo '<br />';
        echo 'Template Type: ' . $templateName . '<br />';
        $invoiceType = $invoice->getType();
        $invoiceStatus = $invoice->getStatus() ? $invoice->getStatus()
->getTitle() : '';
        echo 'Invoice Type: ' . $invoiceType . '<br />';
        echo 'Invoice Status: ' . $invoiceStatus . '<br />';
        echo 'Object Type: ' . $contact->getType() . '<br />';
        echo 'CRM Sprache: ' . $crmLanguageUid . '<br />';
        echo 'Mitgliedschaft: ' . ($invoice->getTemplateMainTag() ?? '[[ohne]]') . '<br />';
        echo 'Status: ' . ($invoice->getTemplateSubTag() ?? '[[ohne]]') . '<br />';
        exit(0);
    }

    public function outInvoice(
        $view,
        $invoices,
        $language = null,
        array $search = [],
        ?bool $usePayments = null,
        InvoiceDate $invoiceDate = null,
        string $additionalFilename = null,
        ?string $letterDate = null
    ) {
        // Content
        $html = '';
        // set format to html for json ajax calls
        $templatePaths = $view->getRenderingContext()
->getTemplatePaths();
        $templatePaths->setFormat('html');


        $templateUtility = GeneralUtility::makeInstance(TemplateUtility::class);
        
        $templatePageLayout = $templateUtility->getTemplatePageLayout(
            'Invoice',
            TemplatePageLayout::PAGE_FORMART_A4,
            TemplatePageLayout::PAGE_ORIENTATION_PORTRAIT,
            ['10mm', '0', '5mm', '0']
        );

        $view->setTemplate('InvoicePrintHtmlEntry.html');

        $pageCount = 0;
        if ($language) {
            $defaultLanguageKey = $language->getTypo3Language();
            $defaultLanguageLocale = $language->getLocale();
        } else {
            die('no default language is set');
            $defaultLanguageKey = 'de';
            $defaultLanguageLocale = 'de_CH.utf8';
        }
        $i = 0;
        //$time_start = microtime(true);
        $templaceCss = [];
        $verband = null;
        $template = null;
        if (!empty($invoices)) {
            foreach ($invoices as $invoice) {
                $i++;
                $debitor = $invoice->getDebitor();
                if (is_object($debitor)) {
                    $languageKey = $debitor->getLanguageCodeWithFallback();
                    $languageLocale = $debitor->getLanguageLocale();
                } else {
                    $languageKey = $defaultLanguageKey;
                    $languageLocale = $defaultLanguageLocale;
                }
                setlocale(LC_ALL, $languageLocale);
                setlocale(LC_TIME, $languageLocale);
                Locale::setDefault($languageLocale);
                $languageMethod = ucfirst((string) $languageKey);
                $language = [
                    'key' => $languageKey,
                    'method' => $languageMethod,
                ];
                $view->assign('language', $language);
                $pageCount++;


                if ($invoiceDate !== null) {
                    $invoice->setStatus($invoiceDate->getStatus());
                    $letterDate = $invoiceDate->getInvoiceDate() ?: $invoiceDate->getCreateDate();
                    $invoice->setInvoiceDate($letterDate);
                    $invoice->setLetterDate($letterDate);
                    $search['letterDate'] = [
                        'date' => $invoiceDate->getInvoiceDate(),
                    ];
                } elseif ($letterDate) {
                    $invoice->setInvoiceDate(new DateTime($letterDate));
                    $invoice->setLetterDate(new DateTime($letterDate));
                }
                $this->assignInvoice($view, $invoice, $usePayments);
                $view->assign('search', $search);


                $contact = $invoice->getDebitor();
                $crmLanguageUid = $this->getCrmLanguageUidByContact($contact);

                $templateUtility->setLanguageUid($crmLanguageUid);
                $templateUtility->setTenant($invoice->getVerband());
                $template = $templateUtility->getTemplate('Invoice', $invoice, $contact);

                if ($template === null) {
                    $this->noTemplateFoundError('Invoice', $invoice, $contact, $crmLanguageUid);
                }
                if ($template instanceof TemplateLetter) {
                    $newCssFiles = $template->getCssFiles();
                    foreach ($newCssFiles as $newCssFile) {
                        if (!in_array($newCssFile, $templaceCss)) {
                            $templaceCss[$newCssFile] = $newCssFile;
                        }
                    }
                }

                $view->assign('template', $template);


                $invoicePrintType = $this->getPdfOutputMode() == self::OUTPUT_PDF_DIE || $this->getPdfOutputMode() == self::OUTPUT_PDF_RETURN ? 'pdf' : 'html';
                $view->assign('invoicePrintType', $invoicePrintType);

                if ($template->getTemplateObjectItemsPerPage()) {
                    $printOnOnePage = $invoice->getInvoiceItem()
->count() < $template->getTemplateObjectItemsPerPage();
                } else {
                    $printOnOnePage = 1;
                }
                $view->assign('usePayments', $usePayments);

                $view->assign('printOnOnePage', $printOnOnePage);
                $class = $pageCount == 1 ? 'page-first-page' : 'page-break-before';
                $html .= '<div class="' . $class . '" data-lang-key="' . $languageKey . '">' . $view->render() . '</div>';

                /*
                 * evtl. einzelne PDFs generieren (fuer QR-Code auf letzter Seite unten)
                 * dann igRender/Utility/PdfUniteUtility.php schreiben mit
                 * /usr/bin/pdfunite Scannen0001.pdf Scannen0002.pdf Scannen0003.pdf combined.pdf
                 * oder https://github.com/myokyawhtun/PDFMerger
                 */
            }
            // add css for layout
            $verband = $invoices[0] instanceof InvoiceInterface ? $invoices[0]->getCreditor() : null;
        }

        $css = $templatePageLayout->getCss();
        if ($template instanceof TemplateLetter) {
            $css .= $template->getCss() . "\n";
        }
        $css .= "\n" . $this->getCss($verband, $templaceCss);
        // Header
        $view->assign('debitorErrorCount', $this->getDebitorErrorCount());
        
        if (1) {
            // do not use templatePageLayout
            $view->setTemplate('InvoicePrintHtmlHeader.html');
            $headerHtml = $view->render();
            $html = $headerHtml . $html;
        } else {
            $view->assign('templatePageLayout', $templatePageLayout);
            $view->assign('content', $html);
            $view->assign('tenant', $verband);
            $view->setTemplate('InvoicePageLayout.html');
            $html = $view->render();
        }
        // PDF/HTML Output
        $pdf = $this->getPdf($additionalFilename);
        $pdf->setCss($css);
        //$pdf->debug($html);exit(0);
        switch ($this->getPdfOutputMode()) {
            case self::OUTPUT_HTML_DIE:
                $pdf->debug($html . $this->getJavaScriptPrintDialog());
                exit(0);
            case self::OUTPUT_HTML_RETURN:
                return $pdf->getHtml($html);
            case self::OUTPUT_PDF_RETURN:
                return $pdf->get($html);
            default:
                $pdf->out($html);
                exit(0);
        }
    }
    
    public function getPdfFilename(?string $additionalFilename = null, int $page = 0): string
    {
        $textInvoice = LocalizationUtility::translate('tx_igfibu_domain_model_invoice', 'igFibu');
        $filenameInvoice = $textInvoice . '-' . ($additionalFilename ?: strftime('%Y-%m-%d'));
        if ($page) {
            $filenameInvoice .= '-' . str_pad($page, 3, '0', STR_PAD_LEFT);
        }
        return $filenameInvoice . '.pdf';
    }

    public static function subtractWithEpsilon(float $a, float $b, float $epsilon = 1e-10): float
    {
        $diff = $a - $b;
        return abs($diff) < $epsilon ? 0 : $diff;
    }
    protected function getPdf(string $additionalFilename = null)
    {
        $pdf = GeneralUtility::makeInstance(PdfUtility::class);
        $pdfFilename = $this->getPdfFilename($additionalFilename);
        $pdf->setFilename($pdfFilename); // TODO Sprache
        $textInvoice = LocalizationUtility::translate('tx_igfibu_domain_model_invoice', 'igFibu');
        $pdf->setTitle($textInvoice);
        $pdf->setConverter(PdfUtility::CONVERTER_WEASYPRINT);
        $pdf->setCssFile('EXT:ig_fibu/Resources/Public/Css/weasyprint.css');
        return $pdf;
    }
    
    private function breakStringIntoBlocks($string, $blocksize = 5, $alignFromRight = true)
    {
        //lets reverse the string (because we want the block to be aligned from the right)
        if ($alignFromRight) {
            $string = strrev((string) $string);
        }//if

        //chop it into blocks
        $string = trim(chunk_split((string) $string, $blocksize, ' '));

        //re-reverse
        if ($alignFromRight) {
            $string = strrev($string);
        }//if

        return $string;
    }

    private function formatIban($iban)
    {
        return $this->breakStringIntoBlocks($iban, 4, false);
    }

    private function debitorErrorMessage($debitor, $debitorAddress = [])
    {
        if (is_object($debitor)) {
            $msg = '<h3 style="color: red;">Debitor Adresse ist unvollständig: Name, PLZ und Ort sind zwingend</h3>
<div  style="color: red;">Name: ' . ($debitorAddress['name'] ?? $debitor->getName()) . '<br />
PLZ: ' . ($debitorAddress['zip'] ?? $debitor->getZip()) . '<br />
Ort: ' . ($debitorAddress['city'] ?? $debitor->getCity()) . '<br />
ID: ' . $debitor->getUid() . ' (' . $debitor->getNumber() . ')<br />
uid: ' . $debitor->getUid() . '<br />
</div>';
        } else {
            $msg = '<h3 style="color: red;">Debitor fehlt</h3>';
        }
        return $msg;
    }
}
