<?php

namespace Ig\IgFibu\ViewHelpers\Invoice;

use Closure;
use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Utility\InvoiceUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ReceiverViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('invoice', Invoice::class, 'invoice to get items', true);
        $this->registerArgument('as', 'string', 'name for contact object ', true);
        $this->registerArgument('else', 'mixed', 'Value to be returned if no debitor is found.', false);
    }

        public function render(): string
    {
        $invoice = $this->arguments['invoice'];

        if ($invoice instanceof Invoice) {
            $invoiceUtility = GeneralUtility::makeInstance(InvoiceUtility::class);
            $invoiceUtility->setReceiver($invoice, false);
            $receiver = $invoiceUtility->getReceiver();
            //var_dump($receiver);exit(0);
            $templateVariableContainer = $this->renderingContext->getVariableProvider();
            $templateVariableContainer->add($this->arguments['as'], $receiver);
            $output = $this->renderChildren();
            $templateVariableContainer->remove($this->arguments['as']);
        } else {
            $output = $this->arguments['else'] ?? '';
        }
        return $output;
    }
}
