<?php

namespace Ig\IgFibu\ViewHelpers\Invoicestatus;

use Closure;
use Ig\IgFibu\Domain\Repository\InvoicestatusRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ShowViewHelper extends AbstractViewHelper
{
    protected static $invoicestatusCache = [];
    
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'invoicestatus uid', true);
        $this->registerArgument('as', 'string', 'name for invoicestatus object ', true);
    }

        public function render(): string
    {
        $invoicestatusUid = $this->arguments['uid'];
        if (!isset(static::$invoicestatusCache[$invoicestatusUid])) {
            $invoicestatusRepository = GeneralUtility::makeInstance(InvoicestatusRepository::class);
            $invoicestatus = $invoicestatusRepository->findByUid($invoicestatusUid);
            static::$invoicestatusCache[$invoicestatusUid] = $invoicestatus;
        } else {
            $invoicestatus = static::$invoicestatusCache[$invoicestatusUid];
        }
        
        if ($invoicestatus === null) {
            return '';
        }
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $invoicestatus);
        $output =  $this->renderChildren();
        $templateVariableContainer->remove($this->arguments['as']);
        return $output;
    }
}
